//variable initialization
m=0.1                                                                           //mass of a spring-mass system (kg)
k=10                                                                            //spring constant of a spring-mass system (newton/meter)
A=0.1                                                                           //Amplitude of system oscillation (meter)
h=(6.625*10^-34)/(2*%pi);                                                        //Planck's constant (joule-second)
delta_n=1                                                                       //change in quantum number

//(a) Quantum number n associated with the energy of the oscillator
f=(k/m)^(1/2);                                                                  //frequency of oscillator (radian/second)
E=0.5*f*A^2;                                                                    //Energy of oscillator (joule)
n=E/(h*f);                                                                      //Quantum number of the oscillator

//(b) Fractional change in energy
change_E=delta_n/n;                                                             //fractional change in energy

//(c) Conclusion: This example illustrates that the energy levels of macroscopic oscillators are so close together that even most delicate instruments cannot reveal the quantized nature of energy levels. All this is due to smallness of Planck’s constant h. In the limit h->0, the energy levels become continuous.

printf("\n(a) Quantum number of the oscillator = %.1e\n(b) Fractional change in energy = %.1e\n(c) This example illustrates that the energy levels of macroscopic oscillators are so close together that even most delicate instruments cannot reveal the quantized nature of energy levels. All this is due to smallness of Planck’s constant h. In the limit h->0, the energy levels become continuous.",n,change_E);

// The answer given in the book for quantum number is just the order of it as it is a very large number. But the answer generated by the code is the exact value of it.
