// finding determinant

clc
clear

// defining matrix
A =[3,2,0,5; 4,1,3,-1; 2,-1,3,6; 5,0,2,-1];

disp('A =', A);

// perform cofactor expansion along last row
// finding submatrix
A_submatrix_4_1 = A(1:3, 2:4); //  delete all entries in the 4th row and all entries in the 1st column
A_submatrix_4_2 = A(1:3, [1 3 4]); // delete all entries in the 4th row and all entries in the 2nd column
A_submatrix_4_3 = A(1:3, [1 2 4]); // delete all entries in the 4th row and all entries in the 3rd column
A_submatrix_4_4 = A(1:3, 1:3); // delete all entries in the 4th row and all entries in the 4th column

// finding minors
// determinant of the submatrix
A_minor_4_1 = det(A_submatrix_4_1);
A_minor_4_2 = det(A_submatrix_4_2);
A_minor_4_3 = det(A_submatrix_4_3);
A_minor_4_4 = det(A_submatrix_4_4);

// finding cofactors
// cofactor = (-1)^index of element * minor
A_cofactor_4_1 = (-1)^(4+1)*det(A_minor_4_1);
A_cofactor_4_2 = (-1)^(4+2)*det(A_minor_4_2);
A_cofactor_4_3 = (-1)^(4+3)*det(A_minor_4_3);
A_cofactor_4_4 = (-1)^(4+4)*det(A_minor_4_4);

// The value of the cofactor varies as in the book, the sign of the term is taken out and used during final calculation of determinant.
// The values provided here are the actual cofactor and minor values calculated unlike the book where intermediate values from matrix is calculated and used in the last.

disp('The corresponding cofactor with (4, 1) submatrix of A is', A_cofactor_4_1);
disp('The corresponding cofactor with (4, 2) submatrix of A is', A_cofactor_4_2);
disp('The corresponding cofactor with (4, 3) submatrix of A is', A_cofactor_4_3);
disp('The corresponding cofactor with (4, 4) submatrix of A is', A_cofactor_4_4);

// finding determinant
// determinant = A(4,1)*cofactor of A(4,1) + A(4,2)*cofactor of A(4,2) + A(4,3)*cofactor of A(4,3) + A(4,4)*cofactor of A(4,4)
determinant = A(4,1)*A_cofactor_4_1 + A(4,2)*A_cofactor_4_2 + A(4,3)*A_cofactor_4_3 + A(4,4)*A_cofactor_4_4;
disp('Therefore determinant of A is', determinant);
