// ex 2.1 -> example 4 -> solving linear equations

clc
clear
warning('off')

// defining matrix
matrix1 = [3,-6,0,3; -2,4,2,-1; 4,-8,6,7];
equation_solution = [9;-11;-5];

// matrix representation of equations
disp('Linear equation can be represented as matrix1,', matrix1, '=', equation_solution);

// two ways to solve problem
// 1. using linsolve
// 2. using Gaussian Elimination, row operations (book method)

// 1.
solution_to_equation = -linsolve(matrix1, equation_solution); // linsolve is to solve a system of equations
if size(solution_to_equation) == 0 then
    disp('The given system of equations have no solutions');
else
   disp('Solutions to the linear equation is', solution_to_equation); 
end

// or

// 2.

// concatenate matrices to create an augmented matrix
disp('2. Using Gaussian Elimination', 'The augmented matrix is');
// create an augmented matrix by appending solution to the equation to original matrix
matrix1_augmented = cat(2,matrix1,equation_solution);
disp(matrix1_augmented);

// position(1,1) is the pivot entry and that row of pivot position is pivot row
// make it equal to 1
// row operation row1 ← 1/3 *row1
disp('After row operation row1 ← 1/3 *row1');
matrix1_augmented(1,:) = matrix1_augmented(1,:)/3
disp(matrix1_augmented);

// targeting entries - make entries below pivot entry equal to 0
// row operation row2 ← 2*row1 + row2
disp('After row operation row2 ← 2*row1 + row2');
matrix1_augmented(2,:) = 2*matrix1_augmented(1,:) + matrix1_augmented(2,:);
disp(matrix1_augmented, '=');
equation_solution(2,:) = 2*equation_solution(1,:) + equation_solution(2,:);
disp(equation_solution);

// targeting entries - make entries below pivot entry equal to 0
// row operation row3 ← -4*row1 + row3
disp('After row operation row3 ← -4*row1 + row3');
matrix1_augmented(3,:) = -4*matrix1_augmented(1,:) + matrix1_augmented(3,:);
disp(matrix1_augmented);

// position(2,2) is the pivot entry and that row of pivot position is pivot row
// but since it is zero and there is no non-zero entry below it
// move to position(2,3) as the pivot entry and the same row as the pivot row
// make it equal to 1
// row operation row2 ← 1/2 *row2
disp('After row operation row2 ← 1/2 *row2');
matrix1_augmented(2,:) = matrix1_augmented(2,:)/2
disp(matrix1_augmented);

// targeting entries - make entries below pivot entry equal to 0
// row operation row3 ← -6*row2 + row3
disp('After row operation row3 ← -6*row2 + row3');
matrix1_augmented(3,:) = -6*matrix1_augmented(2,:) + matrix1_augmented(3,:);
disp(matrix1_augmented);

// position(3,4) is the pivot entry and that row of pivot position is pivot row
// but it is zero and there is no entry below it to switch with

// looking at the equations
disp('Since there is no row below the pivot row3 to switch with, end of augmentation bar is reached.');
disp('From the last row, 0 can not be equal to -2');
disp('Therefore, equation have no solution');


