// ex 1.2 -> example 7 -> component of vector orthogonal to projection vector

clc
clear

// initializing and assigning vectors
a = [4,0,-3];
b = [3,1,-7];

disp('Vectors are', a, 'and', b);

// calculating dot product of vectors
a_b_dot = sum(a.*b);

// calculating magnitude of a
a_norm = norm(a);

// projection vector of b onto a
// projection of b onto a = (b.a/|a|^2)*a 
proj_b_on_a = (a_b_dot/a_norm^2)*a;

disp('Projection vector of b onto a is', proj_b_on_a);

// calculating component of b orthogonal to a and projection vector
b_orthogonal_component = b - proj_b_on_a;

disp('Component of b orthogonal to a and projection vector is', b_orthogonal_component);

// verifying if the b component is orthogonal to a or not
if sum(b_orthogonal_component.*a == 0) then
    disp('Component of b is orthogonal to a');
else
    disp('Component of b is not orthogonal to a');
end

// verifying if the b component is orthogonal to projection vector of b onto a or not
if sum(b_orthogonal_component.*proj_b_on_a == 0) then
    disp('Component of b is orthogonal to projection vector of b onto a');
else
    disp('Component of b is not orthogonal to projection vector of b onto a');
end
