// ex 1.1 -> example 4 -> newton's second law, calculating acceleration to the object

clc
clear

// mass of object in kg
mass = 5;

disp('Mass of object is', mass, 'kg');

// force1 of 10 newtons applied to object in the direction of the vector [−2, 1, 2]
force1_magnitude = 10;
force1_direction = [-2, 1, 2];

// force2 of 20 newtons applied to object in the direction of the vector [6, 3, -2]
force2_magnitude = 20;
force2_direction = [6,3,-2];

// calculating unit vectors in direction of force vectors
force1_norm = norm(force1_direction);
force1_unit = force1_direction/force1_norm

force2_norm = norm(force2_direction);
force2_unit = force2_direction/force2_norm

// calculating net force
force_net = (force1_magnitude*force1_unit) + (force2_magnitude*force2_unit);

disp('Net force applied on object is', force_net);

// calculating net acceleration on object
// force = mass*acceleration => acceleration = force/mass
disp('Acceleration = force/mass');
acceleration_net = force_net/mass;

disp('Net acceleration of object is', acceleration_net);

// calculating length/magnitude of acceleration vector
acceleration_net_norm = norm(acceleration_net);

// Answer varies due to round off error
disp('Magnitude of acceleration is', acceleration_net_norm); // in book magnitude of acceleration is rounded off 3.1773 ≈ 3.18

// calculating unit vector in direction of acceleration
acceleration_net_unit = acceleration_net/acceleration_net_norm;

disp('Acceleration applied on object is', acceleration_net_norm, 'm/sec^2 in the direction',acceleration_net_unit);
