//Example 9.2
//Calculate actual work required, minimum work required and irreversibility of process
clear
clc
p1 = 140; //[kPa]
T1 = 273 + 17; //[K]
V1 = 70; //[m/s]
p2 = 350; //[kPa]
T2 = 273 + 127; //[K]
V2 = 110; //[m/s]
T0 = 273+7; //[K]
Cp = 1.005; //[kJ/kg K]
R = 0.287; 
//(i) Calculate actual amount of work required 
Win_u = Cp*(T2 - T1) + (V2^2 - V1^2)/(2*1000); //[kJ] Actual work input required
//(ii) Calculate the minimum work required
//TdS = dh - vdp
// s2 - s1 = Cplog(T2/T1) - Rlog(p2/p1)
//Φ1 - Φ2 = delΦ = Win_rev =  (h1 - T0*s1)-(h2 - T0*s2)+(V1^2 - V^2)/2
Win_rev = -[Cp*(T1 - T2) - T0*[R*log(p2/p1) - Cp*log(T2/T1)]+(V1^2 - V2^2)/(2*1000)]; //[kJ] Minimum work required
//(iii) Calculate the irreversibility of the process
I = Win_u - Win_rev;//[kJ] Irreversibility of process
disp('Actual amount of work required = ',Win_u,'kJ')
disp('Minimum work required = ', Win_rev,'kJ')
disp('Irreversibility of process = ',I,'kJ')
