//Example 8.8
//Estimate the increase in entropy due to mixing
clear
clc
m_O2 = 5; //[kg]
m_H2 = 2; //[kg]
M_O2 = 32; //[kg/mol] molecular weight of O2
M_H2 = 2; //[kg/mol]   molecular weight of H2
n_O2 = m_O2/M_O2; //[mol]  no. of moles of O2
n_H2 = m_H2/M_H2; // [mol]  no. of moles of H2
x_O2 = n_O2/(n_O2 +n_H2); //mole fraction of O2
x_H2 = 1 - x_O2; // mole fraction of H2
R_bar = 8.314; //[kJ/mol K]
R_O2 = R_bar/M_O2; //[kJ/kg K] 
R_H2 = R_bar/M_H2; //[kJ/kg K]
// Partial pressure of O2 and H2 is equal to their mole fraction
//p_O2/p = x_O2 and p_H2/p = x_H2
del_s =  -(m_O2 *R_O2* log(x_O2) - m_H2*R_H2*log(x_H2) );  //[kJ/K]  s2 - s1 (increase in entropy)
disp('Increase in entropy due to mixing =',del_s,'kJ/K')
