//Example 8.4
//Compute change in enthalpy, work done, heat transferred and final temperature
clear
clc
m = 2; //[kg]
p1 = 600; //[kPa]
T1 = 273 + 20; //[K]
p2 = 300; //[kPa]
gama = 1.4; 
// For an ideal gas, for isentropic process, T2/T1 = (p2/p1)^( (gama- 1)/gama )
T2 = T1*( (p2/p1)^( (gama-1)/gama) ); //[K] final temperature
//(i) Compute the change in enthalpy
R = 0.284; 
del_h =    ( (gama*m*R*T1)/(gama-1) )*[ (p2/p1)^( (gama-1)/gama ) - 1]; //[kJ]
disp('Change in enthalpy =',del_h,'kJ')
//(ii) Compute the work done
//dQ = dU + dW = 0, therefore dW = -dU = U1 - U2 = m(u1 - u2)
W1_2 = ( (m*R*T1)/(gama-1) )*[ 1 - (p2/p1)^( (gama-1)/gama )]; //[kJ]
disp('Work done = ',W1_2,'kJ')
//(iii) Compute the heat transferred
Q = 0; //heat transferred is 0, since the process is reversible adiabatic
disp('Heat transferred =',Q)
//(iv) Compute the final temperature
disp('Final temperature =',T2,'K')
//The answer vary due to round off error
