//Example 8.3
//Find the work done and heat transfer in isothermal and adiabatic process
clear
clc
p1 = 6*100; //[kPa]
V1 = 0.2; //[m^3]
V2 = 1.1; //[m^3]
m = 1.5; //[kg]
//(i) Find the work done and heat transfer in isothermal process
W1_2 = p1*V1*log(V2/V1); //[kJ] work done 
U2_U1 = 0; //Change in internal energy is zero (U2-U1=0)
Q1_2 = U2_U1 + W1_2; //[kJ] Heat transfer
disp('Work done in isothermal process =',W1_2,'kJ')
disp('Heat transfer in isothermal process =',Q1_2,'kJ')
//(ii) Find work done and heat transfer in adiabatic process
gama = 1.4;
p2 = p1*(V1/V2)^gama; //[kPa]
W_adia = (p1*V1 - p2*V2)/(gama - 1); //[kJ] work done
Q = 0; //Heat transfer is 0 since it is adiabatic process
disp('Work done in adiabatic process =',W_adia,'kJ')
 disp('Heat transfer in adiabatic process = ',Q,'kJ')
