//Example 8.10
//Compute Final temperature, Final partialpressure of components and change in internal energy 
clear
clc
m_N2 = 3; //[kg]
m_CO2 = 5; //[kg]
m = m_N2 + m_CO2; //[kg]
M_N2 = 28; //[kg/mol]  mol. wt. of N2
M_CO2 = 44; //[kg/mol] mol. wt. of CO2
P1 = 103; //[kPa]
P2 = 500; //[kPa]
T1 = 273 +25; //[K]
R_bar = 8.314; //[kJ/mol K] gas constant
R_N2 = R_bar/M_N2; //[kJ/kg K]
R_CO2 = R_bar/M_CO2; //[kJ/kg K]
gamma_N2 = 1.4;
Cv_N2 = R_N2/(gamma_N2 - 1); //[kJ/kg K]
Cp_N2 = gamma_N2*Cv_N2; //[kJ/kg K]
gamma_CO2 = 1.286;
Cv_CO2 = R_CO2/(gamma_N2-1); //[kJ/kg K]
Cp_CO2 = gamma_CO2*Cv_CO2; //[kJ/kg K]
Cp = (m_N2*Cp_N2 + m_CO2*Cp_CO2)/(m_N2 + m_CO2); //[kJ/kg K]
Cv = (m_N2*Cv_N2 + m_CO2*Cv_CO2)/(m_N2 + m_CO2); //[kJ/kg K]
//(i) Compute the final temperature
T2 = T1 *(P2/P1)^( (gamma_N2 - 1) /gamma_N2 ); //[K]
disp('Final temperature = ', T2 , 'K')
//(ii) Compute the final partial pressure of component
x_N2 = (m_N2/M_N2)/[ (m_N2/M_N2) + (m_CO2/M_CO2) ]; //Mole fraction of N2
x_CO2 = (m_CO2/M_CO2)/[ (m_N2/M_N2) + (m_CO2/M_CO2)]; //Mole fraction of CO2
p_N2 = x_N2*P2; //[kPa]
p_CO2 = x_CO2*P2; //[kPa]
disp('Final partial pressure of N2 = ', p_N2 ,'kPa')
disp('Final partial pressure of CO2 = ', p_CO2,'kPa')
//(iii) Compute the change in internal energy of mixture during the process
del_U = m*Cv*(T2 - T1); //[kJ]
disp('Change in internal energy of the mixture = ',del_U,'kJ')
//The answer of (iii) is provided wrong in textbook due to calculation mistake
// Total mass should be 8 but it is taken as 7
