//Example 6.6
// Estimate minimum work input required
clear
clc
T1 = 20 + 273; //[K]
T2 = 0 + 273; //[K]
m = 1000; //[kg]  Mass of ice
LH = 335; //[kJ/kg]   Enthalpy of fusion of ice
Cp = 4.2; //[kJ/kg K]   Specific heat capacity of water at constant pressure
COP_R_Rev = T2/(T1 - T2); // COP for reversible refrigerator
Q2 = m*LH + m*Cp*(T1 - T2); //[kJ]  Heat removed by refrigerator from water to produce 1 ton ice
Wnet_in = Q2/COP_R_Rev;//[kJ]
W_min = Wnet_in/3600; //[kW h] Minimum work input required in kW h
disp('Minimum work input required in kW h to produce 1 ton of ice = ', W_min,'kW h')
