//Example 6.5
//Estimate heat rejected to the surroundings and the engine efficiency
clear
clc
T1 = 800; //[K]
T2 = 298; //[K]
Q1 = 900; //[kW]
Wnet_out_1 = 400; //[kW]
eta_thermal = (Wnet_out_1/Q1)*100; //[%] Actual heat engine efficiency
Q2_1 = Q1 - Wnet_out_1; //[kW] Heat rejected to surrounding by actual heat engine 
eta_carnot = 1 - (T2/T1); //Carnot heat engine efficiency 
Wnet_out_2 = eta_carnot*Q1; //[kW] 
Q2_2 = Q1 - Wnet_out_2; //[kW] Heat rejected to surrounding by carnot heat engine
//(i) Estimate heat rejected to the surroundings
disp('Heat rejected by actual heat engine = ',Q2_1,'kW')
disp('Heat rejected by carnot heat engine = ', Q2_2 , 'kW')
//(ii) Estimate the engine efficiency
disp('Actual heat engine efficiency = ', eta_thermal,'%')
disp('Carnot heat engine efficiency = ' , eta_carnot*100 , '%')
