//Example 3.4
//Estimate the net heat transfer
clear
clc
P1 = 1200; //[kPa]    Initial pressure
P2 = 250; //[kPa]    Final pressure
V1 = 0.25; //[m^3]    Initial volume
V2 = 1.35; //[m^3]    Final volume
//given a equation p = a + 2bV 
//from given value two equation are formed
// a + 2*V1*b = 1200;
// a + 2*V2*b = 250;
X = [1 , 2*V1; 1 , 2*V2];
Y = [P1; P2];
Z = inv(X)*Y;
a = Z(1,1);
b = Z(2,1);
disp('a = ' , a) //value of a given in book is wrong
disp('b = ', b)
//now we need to find the value of work transfer
function w = f (V)
    w = a +2*b*V;
endfunction
W = intg(V1, V2, f);
disp('Work transfer = ' , W , 'kJ')
// next we have to find change in internal energy
del_U = 2*(P2*V2) - 2*(P1*V1); //change in internal energy
disp('Change in internal energy',del_U,'kJ')
Q = W + del_U; //net heat transfer
disp('Net heat transfer = ' , Q , ' kJ ') 
// The answer provided in the textbook is wrong
