//Example 14.7
//Determine mass flow rate and heat removed
clear
clc
//From psychrometric chart in Figure Ex 14.7
// At 27°C and 65% relative humidity
h1 = 65; //kJ/kg of dry air
ω1 = 0.017; //kg/kg of dry air
// At 23°C and 45% relative humidity
ha = 30; // kJ/kg of dry air
ω2 = 0.008; // kg/kg of dry air 
m_aw = 85; //[kg/h] Mass flow rate of atmospheric air including moisture
m_a = m_aw/(1 + ω1); //[kg/h] Mass flow rate of air
//(i) Determine mass flow rate of water vapor removed per hour
m_w = m_a*(ω1 - ω2); //[kg/h]  Mass flow rate of water vapor removed per hour
disp('Mass flow rate of water vapor removed per hour = ',m_w,'kg/h')
//(ii) Determine heat removed in cooler per hour
Q = m_a*(h1 - ha); //[kJ/h]
disp('Heat removed in the cooler per hour = ',Q,'kJ/h')
