// Example 14.2
// Determine capacity of cooling and heating coil and amount of water vapor removed
clear
clc
//From psychrometric chart in Figure Ex 14.2
h1 = 61; //kJ/kg of dry air
h2 = 45; //kJ/kg of dry air
h3 = 38; //kJ/kg of dry air
h4 = 35; //kJ/kg of dry air
v1 = 0.865; // m^3/kg dry air
V = 10;//[m^3/s]
ω1 = 0.014;//kg vapor/kg dry air
ω2 = 0.009; //kg vapor/kg dry air
ω3 = ω2;
ma = V/v1; //[kg/s] Mass flow rate of air
//(i)
Cool_cap = ma*(h1 - h3); //[kJ/s] Cooling coil capacity
disp('Cooling coil capacity = ',(Cool_cap*3600)/14000,'Tonnes')
//(ii)
Heat_cap = ma*(h2 - h3); //[kW]  Capacity of heating coil
disp('Capacity of heating coil = ',Heat_cap,'kW')
//(iii)
W_removed = ma*(ω1 - ω3); //[kg/s] Amount of water vapor removed
disp('Amount of water vapor removed = ',W_removed,'kg/s')
