//Example 10.8
//Calculate exergy destruction and the second law efficiency
clear
clc
p1 = 2.5*1000; //[kPa]
t1 = 300; //[°C]
//From superheated steam tables at p1 and t1
h1 = 3009.6; //[kJ/kg]
s1 = 6.645; //[kJ/kg K]
p2 = 15; //[kPa]
// From saturated steam tables at p2 = 15 kPa
sf2 = 0.7549; //[kJ/kg K]
sfg2 = 7.252; //[kJ/kg K]
hf2 = 225.94; //[kJ/kg]
hfg2 = 2373.2; //[kJ/kg]
// s1 = s2 = sf2 + x2 * sfg2
s2 = s1;
x2 = (s2 - sf2)/sfg2; 
h2 = hf2 + x2*hfg2; //[kJ/kg]
h3 = 225.93; //[kJ/kg]  at p2 = 15 kPa hf3 = 225.94
s3 = sf2;
s4 = sf2;
v3 = 0.001014; //[m^3/kg]
wp = v3*(p1 - p2); //[kJ/kg]
h4 = wp + h3; //[k/kg]
wT = h1 - h2; //[kJ/kg] 
q1 = h1 - h4; //[kJ/kg]
q2 = h2 - h3; //[kJ/kg]
T0 = 298; //[K]
T2 = T0; //[K]
T1 = 773; //[K]
//(i) Calculate the exergy destruction
X_destroyed_23 = T0*[s3 - s2 + (q2/T2)]; //[kJ/kg]
X_destroyed_41 = T0*[s1 - s4 - (q1/ T1) ]; //[kJ/kg]
// X_desroted=X_destroyed_12+X_destroyed_23+X_destroyed_34+X_destroyed_41
//X_destroyed_12 = 0 & X_destroyed_34 = 0
X_destroyed = X_destroyed_23 + X_destroyed_41; //[kJ/kg]
disp('Exergy destruction =',X_destroyed,'kJ/kg')
//(ii) Calculate the second law efficiency
X_heat_in = (q1 - q2) + X_destroyed;
X_pump_in =  wp; //[kJ/kg]
X_supplied = X_heat_in + X_pump_in; //[kJ/kg]
eta_pi = [1 - (X_destroyed/X_supplied)]*100; //[%]
disp('The second law efficiency is =',eta_pi,'%')
//The answer vary due to round off error
