// Scilab Code for 7.21
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex7_21.txt")
m1 = 10 ;  // Mass of Steam in g
m2 = 90 ;  // Mass of water in g
L = 540 ;  // Latent heat  in cal/g
s = 1 ; // specefic heat of cal g^(-1) K^(-1)
T1 = 100+273  ;   // Temperature in K
T2 = 0+273 ;   // Temperature in K
del_S1 = - m1*L/T1  ;   // Change in Entropy during Condensation
disp(" Change in Entropy during Condensation in cal/K ;",del_S1)
T = (m1*L + m1*s*T1 + m2*s*T2)/(m1*s + m2*s) ;  // Temperature of mixing in K
disp(" Temperature of mixing in K is ;",T)
del_S2 = m1*s*log(T/T1) ;  // Change in Entropy from 373 to 335
disp(" Change in Entropy from 373 tom 335 in cal/K is ;",del_S2)
del_S3 = m2*s*log(T/T2) ; // Change in Entropy from 273 to 335
disp(" Change in Entropy from 273 to 335 cal/K is ;",del_S3)
disp(" Total Increase in Entropy in cal/K  is ;",del_S1+del_S2+del_S3)


/* Result

  Change in Entropy during Condensation in cal/K 

  -14.477212      ,    "Answer given in textbook is wrong" 

  Temperature of mixing in K is 

   337           ,    "Answer given in textbook is wrong" 

  Change in Entropy from 373 tom 335 in cal/K is 

  -1.0149549       , " Answer given in the textbook are wrong "

  Change in Entropy from 273 to 335 cal/K is 

   18.955002     ,   " Answer given in the textbook are wrong "

  Total Increase in Entropy in cal/K  is 

   3.4628355     ,   " Answer given in the textbook are wrong "
  
