// Scilab Code for 6.24
diary("Ex6_24.txt")
clc
// a to b  Isochoric compression
// b to c  Adiabatic Expansion 
// c to a  Isothermal compression 
// del_Wab = 0    As the process is isochoric
R = 8.314 ;   // Gas Constant
Tb = 300 ;    //  Temperature in Kelvin 
Ta = 30 ;     //  Temperature in Kelvin  
p = 5*10^2 ;   // Pressure in N/m^2
V = 2*10^(-3) ;   // Volume in m^3
n = p*V/(R*Ta)  ;    // number of moles of gas in J/K
Cv = (3/2)*R   ;     // Specefic heat 
Gamma = 1.67 // ratio of Cp/Cv

// a to b
Qab = n*Cv*(Tb-Ta);      // Heat absorbed in J from a to b
disp(" Heat absorbed in J from a to b is; ",Qab)
// Ua = Uc = 0    Internal energy at a and c
Ub = Qab ;   // Internal energy in J at b 
disp(" Internal energy in J at b  is; ",Ub)
// b to c 
// Qbc = 0  Heat absorbed from b to c 
Wbc = Ub ;   //  Work done in J from b to c
disp("Work done in J from b to c is ",Wbc)
// c to a 
Vc_Vb = (Tb/Ta)^(1/(Gamma-1)) ;   // Ratio of volume at c and b 
disp("Vc/Vb is ",Vc_Vb)
Wca = -n*R*Ta*log(Vc_Vb) ;   // work done in J from c to a
disp("Work done in J from c to a is ",Wca)
Qca = Wca ;   //  heat absorbed in J from c to a
disp(" Heat absorbed in J from c to a is; ",Qca)
disp("Net work done in J is",Wbc+Wca)
disp(" Heat absoebed in J is ", Qab)
Eta = ((Wbc+Wca)/(Qab))*100 ;     //  Efficiency in %
disp("Efficiency in % is" ,Eta)





/* Result 
 
  
   13.5

  Heat absorbed in J from a to b is; 

   13.5

  Internal energy in J at b  is; 

   13.5

 Work done in J from b to c is 

   31.08403

 Vc/Vb is 

  -3.4366942

 Work done in J from c to a is 

  -3.4366942

  Heat absorbed in J from c to a is; 

   10.063306

 Net work done in J is

   13.5

  Heat absoebed in J is 

   74.543006

 Efficiency in % is
 
 "Answer varies due to round off error"
 
 
   */
