// Scilab Code for 6.14
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex6_14.txt")
Y = 1.4 ;  // Adiabatic Conatant 
M = 28.97 ;  // Molecular wt. of air in Kg 
Cp = 29.2 ;  // Specefic heat at constant Pressure in J mol^(-1) K^(-1)
Q1 = 600 ; // Heat Intake in KJ Kg^(-1)
T3 = 1200  ;  // Temperature in Kelvin
T1 = 300  ;  // Temperature in Kelvin
T2 = T3 - (Q1*M)/Cp ;  // Temperature in Kelvin
disp(" Temperature in Kelvin is ;",T2)
// For the Adiabatic process a -> b 
p1 = 120 ;   // Pressure in KPa
p2 = p1*(T2/T1)^(Y/(Y-1))  ;   // Pressure in KPa
disp(" Pressure in KPa , p2 ; ",p2)
rho_c = (p2/p1)^(1/Y) ;  //  Compression Ratio 
disp("The Compression Ratio is ;",rho_c)
r_c = T3/T2 ;     //  The cut-off Ratio
disp("The Cut off Ratio is ;",r_c)
// For the process b -> c
eta = 1 - (r_c^Y-1)/((r_c-1)*Y*rho_c^(Y-1)) ;   //  Efficiency of the engine 
disp("Efficiency of the engine ;",eta)



/*

Result

 
   604.72603

  Temperature in Kelvin is ;

   1395.4432

  Pressure in KPa , p2 ; 

   5.7689067

 The Compression Ratio is ;

   1.9843697

 The Cut off Ratio is ;

   0.4203676

 Efficiency of the engine ;
 
 "Answer varies due to round off error"
*/
