// Scilab Code for 4.2
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex4_2.txt")
alpha = 48*10^(-6)  ;  // Expansivity of copper in per K
Et = 1.3*10^(11) ;   //  Isothermal elasticity of copper in N m^(-2)
T1 = 0 + 273 ;    //  Temperature  in Kelvin
T2 = 10 + 273 ;    //  Temperature  in Kelvin
// T2 - T1 = delta_T
p1 = 1 ;     //  Atmospheric Pressure in atm
V1 = 1000 ;  //  Volume in cc at T1
V2 = 1000.1 ;    // Volume in cc  at T2
dV = (V2-V1)*10^(-6)  ;   //  Change in Volume in m^3
// (a) Final Pressure in atm when V is fixed
dp =  alpha*Et*(T2-T1) ;  //  Final Pressure in N m^(-2)
p2 = dp/10^(5) + p1 ;   // Final Pressure in atm 
disp("(a) Final Pressure in atm is ;",p2)
// (b) Final Pressure in atm when V increases
dp =  - (Et*dV/(V1*10^(-6))) + (alpha*Et*(T2-T1)) ;  //  Final Pressure in atm when V increases in N m^(-2)
p2 = dp/10^(5) + p1 ;  // Final Pressure in atm 
disp("(b) Final Pressure in atm when V increases is ;",p2)


/*
Result

 625.

 (a) Final Pressure in atm is ;

   495.

 (b) Final Pressure in atm when V increases  is ;
 
 */
