// Scilab Code for 2.9
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_9.txt")
d = 2.92*10^(-10) ;   //Molecular diameter of the hydrogen molecule in m
m = 2.016*1.66*10^(-27) ;  //   mass in Kg
T = 27 + 273 ;  //   Temperature in Kelvin
kb = 1.38*10^(-23) ;   //  Boltzmann constant in J/K
Vmean = sqrt((8*kb*T)/(%pi*m)) ; //  average speed in m/sec
disp(" average speed in m/sec is ;",Vmean)
eta = (m*Vmean)/(3*2^(1/2)*%pi*d^2) ;  //  Coefficient of viscosity of Hygrogen gas  in  10^(-6) Nsm^(-2)
disp(" Coefficient of viscosity of Hygrogen gas  in 10^(-6) Nsm^(-2) is; ",eta/10^(-6))

/*  Result 

  8.853D-08

  mean free path in m is ; 

   3.069D-10

  Molecular diameter of the gas in m is;
  
  "Answer vary due to round off error"
  
   */
