// Scilab Code for 2.7
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_7.txt")
eta = 2*10^(-4) ;  // Coefficient of viscosity of Helium in poise  , 1poise = 0.1 Kg m^(-1) sec^(-1)
T = 27 + 273 ;  // Temperature in Kelvin
kb = 1.38*10^(-23) ;   //  Boltzmann constant in J/K
Na = 6*10^23  ;    // Avagadro Number in per mol
m = 4/(Na*10^3) ;   // mass in Kg
disp("Mass of He molecule in Kg ; ",m)
Vmean = sqrt(2.55*kb*T/m) ;   //  mean Speed in m/sec
disp(" mean Speed in m/sec is ;",Vmean )
d = sqrt((m*Vmean)/(3*2^(1/2)*%pi*eta*0.1)) ;  //  Diameter of Helium molecule in m
disp(" Diameter of Helium molecule in m is; ",d)


/* Result 

  6.667D-27

 Mass of He molecule in Kg ; 

   1258.3918

  mean Speed in m/sec is ;

   1.774D-10        "Answer varies due to round of error"

  Diameter of Helium molecule in m is;
  
   */
