// Scilab Code for 2.20
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_20.txt")
eta = 1.66*10^(-5) ;  // Coefficient of viscosity of gas in Nsm^(-2)
Vmean = 450 ;    //  Average molecular speed in m/sec
rho = 1.25 ;   // Density of ther gas in Kg m^(-3) 
// (a) Meab free path of the gas
lambda = (3*eta)/(rho*Vmean) ;  //  Mean free p-ath in m 
disp(" Mean free p-ath in m is ;",lambda)
// (b) Collision frequency 
f = Vmean/lambda ;  // Collision frequency per sec
disp( " Collision frequency per sec is ;",f) 
// (c) Molecular diameter of in m
V = 22.4*10^(-3) ;   // Volume in m^3
Na = 6.023*10^23 ;   // Avagadro Number 
n = Na/V ;   // Number density in per m^3
disp(" Number density in per m^3 is ;",n)
d = sqrt(1/(sqrt(2)*%pi*lambda*n)) ;   // Molecular diameter in m
disp( " Molecular diameter in m is ;",d)

/*  Result 

  
   8.853D-08

  Mean free p-ath in m is ;

   5.083D+09

  Collision frequency per sec is ;

   2.689D+25

  Number density in per m^3 is ;

   3.075D-10

  Molecular diameter in m is ;

   */
