// Scilab Code for 2.16
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex2_16.txt")
Kb = 1.38*10^(-23)  ;   //  Boltzmann Constant in J/K
d = 10^(-10) ;  // diameter of N2 molecule in m
T = 27 + 273 ;  // Temperature in Kelvin
p = 1.013*10^(5) ;  // Pressure in N m^(-2)
m = 28/(6.023*10^26) ;  // mass in Kg
lambda = (Kb*T)/(2^(1/2)*%pi*d^2*p) ;   // Mean free path in m
disp(" Mean free path in 10^(-6) m is ;",lambda/10^(-6))
Vmean = sqrt(2.55*Kb*T/m) ;   // mean speed in m/sec
disp(" mean speed in m/sec is ;",Vmean)
t = lambda/Vmean ;   // Mean time between collision in sec
disp(" Mean time between collision in sec is ;",t)

/* Result 


   0.9198691

  Mean free path in 10^(-6) m is ;

   476.53815

  mean speed in m/sec is ;

   1.930D-09

  Mean time between collision in sec is ;
  
  "Answer vary due to round off error"
   */
