// Scilab Code for 11.17
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex11_17.txt")
sigma = 5.672*10^(-8) ;   // Stephen's Constant in J m^(-2) K^(-4) s^(-1) 
c = 3*10^8 ;  // Speed of light in m/sec
Ti = 2500 ;   // Initial Temperature in Kelvin
p = (4*sigma*(Ti^4))/(3*c)  ;   // Pressure in N/m^2
disp("(a) Pressure in N/m^2 10^(-2) is ;",p/10^(-2))
del_V = 1.01*10^(-3)  -  10^(-5)  ;  // Change in Volume in m^3
W = p*del_V ;   // Work done in J
disp("(b) Work done in 10^(-5) J is ;",W/10^(-5))
Tf = Ti*((100)^(1/3))  ;  // Final Temperature in Kelvin
disp("(c) Final Temperature in Kelvin is ;",Tf)


 

/* 
Result

  0.9847222      ,  "Answer given in textbook is wrong"  "T used is different"

 (a) Pressure in N/m^2 10^(-2) is ;

   0.9847222    , ,  "Answer given in textbook is wrong"  "T used is different"

 (b) Work done in 10^(-5) J is ;

   11603.972

 (c) Final Temperature in Kelvin is ;
   */
