// Scilab Code for 11.12
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex11_12.txt")
v = 1.5*10^14 ;  // Frequency of oscillator in Hz
Kb = 1.38*10^(-23) ;  // Boltzmann Constant in J/K
h = 6.62*10^(-34)  ;  // Plancks Constant in J/s
T = 1800 ;  // Temperature in Kelvin
// (a) Average energy of Classical oscillator
epsilon_bar = Kb*T ;  // Average energy of Classical oscillator in J 
disp("(a) Average energy of Classical oscillator in J is ;",epsilon_bar)
// (a) Average energy of Plancks oscillator
epsilon_bar = (h*v)/(exp((h*v)/(Kb*T))-1)  ;   // Average energy of Plancks oscillator in J 
disp("(b) Average energy of Plancks oscillator in J is ;",epsilon_bar)


/* Result
  
   2.484D-20

 (a) Average energy of Classical oscillator in J is ;

   1.857D-21     ,    "Answer given in textbook is Wrong"

 (b) Average energy of Plancks oscillator in J is ;
     
   */
