//Example 5.2
clc

W=1000//total weight in kg

Cp1=3.50//carbon content in pig iron 1
Cp2=3.20//carbon content in pig iron 2
Cp3=3.50//carbon content in pig iron 3
Cs1=3.50//carbon content in scrap 1
Cs2=3.20//carbon content in scrap 2

Sip1=3.00//silicon content in pig iron 1
Sip2=1.50//silicon content in pig iron 2
Sip3=2.50//silicon content in pig iron 3
Sis1=1.80//silicon content in scrap 1
Sis2=1.20//silicon content in scrap 2
FSi=50.00//silicon content in ferrosilicon

Map1=1.00//manganese content in pig iron 1
Map2=0.50//manganese content in pig iron 2
Map3=0.80//manganese content in pig iron 3
Mas1=0.60//manganese content in scrap 1
Mas2=0.60//manganese content in scrap 2

Sup1=0.02//sulphur content in pig iron 1
Sup2=0.01//sulphur content in pig iron 2
Sup3=0.02//sulphur content in pig iron 3
Sus1=0.08//sulphur content in scrap 1
Sus2=0.10//sulphur content in scrap 2

//pig iron 2 and scrap 2 has got very low silicon and therefore it should not be used.

cp1=30//% in the charge of pig iron 1
cp3=30//% in the charge of pig iron 3
cs1=40//% in the charge of scrap 1

Wp1=cp1*W/100//weight of pig iron 1 in kg
Wp3=cp3*W/100//weight of pig iron 2 in kg
Ws1=cs1*W/100//weight of grey iron scrap in kg

Ccp1=Cp1*cp1/100//% of carbon in charge of pig iron 1
Ccp3=Cp3*cp3/100//% of carbon in charge of pig iron 3
Ccs1=Cs1*cs1/100//% of carbon in charge of scrap 1

Sicp1=Sip1*cp1/100//% of silicon in charge of pig iron 1
Sicp3=Sip3*cp3/100//% of silicon in charge of pig iron 3
Sics1=Sis1*cs1/100//% of silicon in charge of scrap 1

Macp1=Map1*cp1/100//% of manganese in charge of pig iron 1
Macp3=Map3*cp3/100//% of manganese in charge of pig iron 3
Macs1=Mas1*cs1/100//% of manganese in charge of scrap 1

Sucp1=Sup1*cp1/100//% of sulphur in charge of pig iron 1
Sucp3=Sup3*cp3/100//% of sulphur in charge of pig iron 3
Sucs1=Sus1*cs1/100//% of sulphur in charge of scrap 1

Ctc=Ccp1+Ccp3+Ccs1//% of total in charge of carbon
Sitc=Sicp1+Sicp3+Sics1//% of total in charge of silicon 
Matc=Macp1+Macp3+Macs1//% of total in charge of manganese
Sutc=Sucp1+Sucp3+Sucs1//% of total in charge of sulphur

Cc=0.15//change in cupola in carbon
Suc=0.05//change in cupola in sulphur
Sil=10//% of loss in silicon
Mal=20//% of loss in manganese
Sic=-Sil*Sitc/100//change in cupola in silicon
Mac=-Mal*Matc/100//change in cupola in manganese

CC=Ctc+Cc//% of estimated composition of carbon
printf('Estimated composition of Carbon is %f %% \n',CC)
//required composition of carbon is 3.2 to 3.6 %
Cl=3.2//% of lowest required composition of carbon
Ch=3.6//% of highest required composition of carbon
SiC=Sitc+Sic//% of estimated composition of silicon
printf('Estimated composition of Silicon is %f %% \n',SiC)
//required composition of Silicon is 2.3 to 2.6 %
MaC=Matc+Mac//% of estimated composition of manganese
printf('Estimated composition of Manganese is %f %% \n',MaC)
//required composition of manganese is 0.6 to 0.8 %
SuC=Sutc+Suc//% of estimated composition of sulphur
printf('Estimated composition of Sulphur is %f %% \n\n',SuC)
//required composition of sulphur is 0.08 % max
Sur=0.08//% of maximum required composition of sulphur

SuR=(Sus1-Sup2)/100//reduction in sulphur in kg --> addition of 1 kg of pig iron 2 for scrap 1
CR=(Cs1-Cp2)/100//reduction in carbon in kg --> addition of 1 kg of pig iron 2 for scrap 1
SuE=W*(SuC-Sur)/100//excess sulphur present in 1000 kg in kg
CE=W*(CC-Ch)/100//excess carbon present in 1000 kg in kg
Surd=SuE/SuR//reduce the sulphur to the desirable limit in kg
Crd=CE/CR//reduce the carbon to the desirable limit in kg

//substitution of Surd of pig iron would be sufficient to give the desired analysis.

Wsn1=W-Wp1-Wp3-Surd//weight of the new scrap 1 in kg
cp2=Surd*100/W//% in the charge of pig iron 2
csn1=Wsn1*100/W//% in the charge of new scrap 1

Ccp2=Cp2*cp2/100//% of carbon in charge of pig iron 2
Ccsn1=Cs1*csn1/100//% of carbon in charge of new scrap 1

Sicp2=Sip2*cp2/100//% of silicon in charge of pig iron 2
Sicsn1=Sis1*csn1/100//% of silicon in charge of new scrap 1

Macp2=Map2*cp2/100//% of manganese in charge of pig iron 2
Macsn1=Mas1*csn1/100//% of manganese in charge of new scrap 1

Sucp2=Sup2*cp2/100//% of sulphur in charge of pig iron 2
Sucsn1=Sus1*csn1/100//% of sulphur in charge of new scrap 1

Cntc=Ccp1+Ccp2+Ccp3+Ccsn1//% of new total in charge of carbon
Sintc=Sicp1+Sicp2+Sicp3+Sicsn1//% of new total in charge of silicon 
Mantc=Macp1+Macp2+Macp3+Macsn1//% of new total in charge of manganese
Suntc=Sucp1+Sucp2+Sucp3+Sucsn1//% of new total in charge of sulphur

Sinc=-Sil*Sintc/100//new change in cupola in silicon
Manc=-Mal*Mantc/100//new change in cupola in manganese

CnC=Cntc+Cc//% of new estimated composition of carbon
printf('New estimated composition of Carbon is %f %% \n',CnC)
SinC=Sintc+Sinc//% of new estimated composition of silicon
printf('New estimated composition of Silicon is %f %% \n',SinC)
ManC=Mantc+Manc//% of new estimated composition of manganese
printf('New estimated composition of Manganese is %f %% \n',ManC)
SunC=Suntc+Suc//% of new estimated composition of sulphur
printf('New estimated composition of Sulphur is %f %% \n\n',SunC)

Sia=W*(Sintc-SinC)/100//amount of silicon to be added for 1000 kg in kg
FSia=Sia*100/(FSi-Sis1)//amount of ferro silicon required in kg by adding silicon in place of scrap 1
FSia1p=FSia*100/W//% of ferro silicon content
Ws1c=Wsn1-FSia//weight of scrap 1 content in kg
S1cp=(Wsn1-FSia)*100/W//% of scrap 1 content

printf('Final mix of the charge is \n Pig iron 1 = %f kg (%f %%) \n Pig iron 2 = %f kg (%f %%) \n Pig iron 3 = %f kg (%f %%) \n Scrap 1 = %f kg (%f %%) \n Ferro silicon = %f kg (%f %%) ',Wp1,cp1,Surd,cp2,Wp3,cp3,Ws1c,S1cp,FSia,FSia1p)
//the answer may slightly vary due to rounding off values
