// Chapter No :6  Exercise Number : 6.5 of the Book Name : Cryptography and Network Security by Behrouz Forouzan, Special Indian Edition, 2007
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Pranav Sreenivasarao 16BCE1361  Anamay Prateek (16BCCE1267)) Guided by Dr. T. Subbulakshmi, Professor
//School of Computing Science and Engineering, VIT University Chennai 

//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 


clc;
clear;
function bin=hex2bin(hex)
    bin=""
    for i=1:length(hex)
        temp=dec2bin(hex2dec(part(hex,i:i)),4)
        bin=bin+temp
    end
endfunction

function hex=bin2hex(bin)
   hex=""
   for i=1:length(bin)/4
        temp=""
        for j=1:4
            temp=temp+part(bin,(i-1)*4+j:(i-1)*4+j)
        end
        hex=hex+dec2hex(bin2dec(temp))
    end
endfunction

function lshft=shift(shft,no)
    lshft=""
    for n=1:no
        temp=shft(1)
        for o=2:28
            shft(o-1)=shft(o)
        end
        shft(28)=temp
    end
    lshft=shft
endfunction

function [i_p,l,r,i_p_b,l_b,r_b]=ini_perm(plain)
    p_bin=hex2bin(plain)
    q="0000000000000000000000000000000000000000000000000000000000000000"
    for i=1:64
        gg(i)=part(q,i:i)
    end
    m=[
    58 50 42 34 26 18 10 2;
    60 52 44 36 28 20 12 4;
    62 54 46 38 30 22 14 6;
    64 56 48 40 32 24 16 8;
    57 49 41 33 25 17 09 1;
    59 51 43 35 27 19 11 3;
    61 53 45 37 29 21 13 5;
    63 55 47 39 31 23 15 7]
    for k=1:64
        for i=1:8
            for j=1:8
                if(k==m(i,j))
                    gg((i-1)*8+j)=part(p_bin,k:k)
                end
            end
        end
    end
    i_p_b=""
    l_b=""
    r_b=""
    for i=1:length(q)
        i_p_b=i_p_b+gg(i)
        if i<=length(q)/2
            l_b=l_b+gg(i)
        else
            r_b=r_b+gg(i)
        end
    end
    r=bin2hex(r_b)
    i_p=bin2hex(i_p_b)
    l=bin2hex(l_b)
endfunction

function res=fin_perm(inp)
    l=[
    40 8 48 16 56 24 64 32;
    39 7 47 15 55 23 63 31;
    38 6 46 14 54 22 62 30;
    37 5 45 13 53 21 61 29;
    36 4 44 12 52 20 60 28;
    35 3 43 11 51 19 59 27;
    34 2 42 10 50 18 58 26;
    33 1 41 9 49 17 57 25]
    for k=1:64
        for i=1:8
            for j=1:8
                if(k==l(i,j))
                    ss((i-1)*8+j)=part(inp,k:k)
                end
            end
        end
    end
    res=""
    for i=1:64
        res=res+ss(i)
    end
endfunction

function rk=genroundkey(lb,rb)
    kct=[
    14 17 11 24 01 05 03 28;
    15 06 21 10 23 19 12 04;
    26 08 16 07 27 20 13 02;
    41 52 31 37 47 55 30 40;
    51 45 33 48 44 49 39 56;
    34 53 46 42 50 36 29 32]
    for k=1:56
        for i=1:6
            for j=1:8
                if k==kct(i,j)
                    if k<=28
                        uu((i-1)*8+j)=lb(k)
                    else
                        uu((i-1)*8+j)=rb(k-28)
                    end
                end
            end
        end
    end
    rk=""
    for i=1:48
        rk=rk+uu(i)
    end
    l=""
    r=""
    for i=1:28
        l=l+lb(i)
        r=r+rb(i)
    end
endfunction

function ru=func(y,test)
    sbox=[
    14 4 13 1 2 15 11 8 3 10 6 12 5 9 0 7;
    0 15 7 4 14 2 13 1 10 6 12 11 9 5 3 8;
    4 1 14 8 13 6 2 11 15 12 9 7 3 10 5 0;
    15 12 8 2 4 9 1 7 5 11 3 14 10 0 6 13;
    
    15 1 8 14 6 11 3 4 9 7 2 13 12 0 5 10;
    3 13 4 7 15 2 8 14 12 0 1 10 6 9 11 5;
    0 14 7 11 10 4 13 1 5 8 12 6 9 3 2 15;
    13 8 10 1 3 15 4 2 11 6 7 12 0 5 14 9;
    
    10 0 9 14 6 3 15 5 1 13 12 7 11 4 2 8;
    13 7 0 9 3 4 6 10 2 8 5 14 12 11 15 1;
    13 6 4 9 8 15 3 0 11 1 2 12 5 10 14 7;
    1 10 13 0 6 9 8 7 4 15 14 3 11 5 2 12;
    
    7 13 14 3 0 6 9 10 1 2 8 5 11 12 4 15;
    13 8 11 5 6 15 0 3 4 7 2 12 1 10 14 9;
    10 6 9 0 12 11 7 13 15 1 3 14 5 2 8 4;
    3 15 0 6 10 1 13 8 9 4 5 11 12 7 2 14;
    
    2 12 4 1 7 10 11 6 8 5 3 15 13 0 14 9;
    14 11 2 12 4 7 13 1 5 0 15 10 3 9 8 6;
    4 2 1 11 10 13 7 8 15 9 12 5 6 3 0 14;
    11 8 12 7 1 14 2 13 6 15 0 9 10 4 5 3;
    
    12 1 10 15 9 2 6 8 0 13 3 4 14 7 5 11;
    10 15 4 2 7 12 9 5 6 1 13 14 0 11 3 8;
    9 14 15 5 2 8 12 3 7 0 4 10 1 13 11 6;
    4 3 2 12 9 5 15 10 11 14 1 7 6 0 8 13;
    
    4 11 2 14 15 0 8 13 3 12 9 7 5 10 6 1;
    13 0 11 7 4 9 1 10 14 3 5 12 2 15 8 6;
    1 4 11 13 12 3 7 14 10 15 6 8 0 5 9 2;
    6 11 13 8 1 4 10 7 9 5 0 15 14 2 3 12;
    
    13 2 8 4 6 15 11 1 10 9 3 14 5 0 12 7;
    1 15 13 8 10 3 7 4 12 5 6 11 0 14 9 2;
    7 11 4 1 9 12 14 2 0 6 10 13 15 3 5 8;
    2 1 14 7 4 10 8 13 15 12 9 0 3 5 6 11]
    spt=[
    16 7 20 21 29 12 28 17;
    1 15 23 26 5 18 31 10;
    2 8 24 14 32 27 3 9;
    19 13 30 6 22 11 4 25]
    epbt=[
    32 1 2 3 4 5;
    4 5 6 7 8 9;
    8 9 10 11 12 13;
    12 13 14 15 16 17;
    16 17 18 19 20 21;
    20 21 22 23 24 25;
    24 25 26 27 28 29;
    28 29 30 31 32 1]
    for k=1:32
        for i=1:8
            for j=1:6
                if k==epbt(i,j)
                    ff((i-1)*6+j)=part(y,k:k)
                end
            end
        end
    end
    for i=1:48
        if part(test,i:i)==ff(i)
            nn(i)="0"
        else
            nn(i)="1"
        end
    end
    temp=""
    for i=1:8
        row=bin2dec(nn((i-1)*6+1)+nn((i-1)*6+6))
        col=bin2dec(nn((i-1)*6+2)+nn((i-1)*6+3)+nn((i-1)*6+4)+nn((i-1)*6+5))
        temp=temp+dec2bin(sbox((i-1)*4+row+1,col+1),4)
    end
    for k=1:32
        for i=1:4
            for j=1:8
                if k==spt(i,j)
                    dd((i-1)*8+j)=part(temp,k:k)
                end
            end
        end
    end
    ru=""
    for i=1:32
        ru=ru+dd(i)
    end
endfunction

p="123456ABCD132536"
key="AABB09182736CCDD"
disp("Plain Text : "+p)
disp("Key : "+key)

keyb=hex2bin(key)
for i=1:length(keyb)
    ah(i)=part(keyb,i:i)
end

q="00000000000000000000000000000000000000000000000000000000"
for i=1:length(q)
    qq(i)=part(q,i:i)
end
pbdt=[
57 49 41 33 25 17 09 01;
58 50 42 34 26 18 10 02;
59 51 43 35 27 19 11 03;
60 52 44 36 63 55 47 39;
31 23 15 07 62 54 46 38;
30 22 14 06 61 53 45 37;
29 21 13 05 28 20 12 04]

for k=1:64
    for i=1:7
        for j=1:8
            if k==pbdt(i,j)
                qq((i-1)*8+j)=ah(k)
            end
        end
    end
end

i_p_b=""
l_b=""
r_b=""
for i=1:length(q)
    i_p_b=i_p_b+qq(i)
    if i<=length(q)/2
        l_b=l_b+qq(i)
    else
        r_b=r_b+qq(i)
    end
end
r=bin2hex(r_b)
i_p=bin2hex(i_p_b)
l=bin2hex(l_b)

[i,l,r,ib,lb,rb]=ini_perm(p)
disp("After initial permutation : "+i+"    "+ib)
disp("L0 = "+l+"    "+lb)
disp("R0 = "+r+"    "+rb)

lbn=qq(1:28)
rbn=qq(29:56)
disp("")
disp("Round        Left      Right        RoundKey  ")
for z=1:16
    if z==1
        n=1
    elseif z==2
        n=1
    elseif z==9
        n=1
    elseif z==16
        n=1
    else
        n=2
    end
    lbn=shift(lbn,n)
    rbn=shift(rbn,n)
    rkn=genroundkey(lbn,rbn)
    lb_n=func(rb,rkn)
    lb=dec2bin(bitxor(bin2dec(lb_n),bin2dec(lb)),32)
    if z<16
        temp=rb
        rb=lb
        lb=temp
    end
    disp("Round"+string(z)+"     "+bin2hex(lb)+"    "+bin2hex(rb)+"    "+bin2hex(rkn))
end
fp=fin_perm(lb+rb)
disp("")
disp("(L16+R16) : "+bin2hex(lb+rb)+"    "+lb+rb)
disp("Cipher Text Afer Final Permutation : "+bin2hex(fp))
