clc
clear
close;

N=256; //samples number
n=-(N/2):N/2-1;
x=1.*((n>=-4)&(n<=4));
omega=[-N/2:(N/2)-1]*2*%pi/N;
X=fft(x);
X_mode=fftshift(abs(X));
X=round(X*10000)/10000;
X_angle=fftshift(phasemag(X)*%pi/180);

figure(1)
subplot(3,1,1);plot2d3(n,x,[2]);
title("Discrete rect pulse","fontsize",4);
set(gca(),"zoom_box",[-10 0 10 1.1],"y_location","middle");
subplot(3,1,2);plot(omega,X_mode,'r');
set(gca(),"y_location","middle");
title("|X(w)|","fontsize",4);
subplot(3,1,3);plot(omega,X_angle,'r');
set(gca(),"y_location","middle");
title("angle(X(w))","fontsize",4)
