//page 187
//Example 6.3
clc;
clear;
close;
disp('Standard ordered matrix for Linear operator T on R^3 is:');
A = [5 -6 -6; -1 4 2; 3 -6 -4];
disp(A,'A = ');
disp('xI - A = ');
B = eye(3,3);
x = poly(0,"x");
P = x*B - A;
disp(P);
disp('Applying row and column transformations:');
disp('C2 = C2 - C3');
P(:,2) = P(:,2) - P(:,3);
disp('=>');
disp(P);
disp('Taking (x-2) common from C2');
c = x-2;
P(:,2) = P(:,2) / (x-2);
disp('=>');
disp(' * ', c);
disp(P);
disp('R3 = R3 + R2');
P(3,:) = P(3,:) + P(2,:);
disp('=>');
disp(' * ', c);
disp(P);
P = [P(1,1) P(1,3); P(3,1) P(3,3)];
disp('=>');
disp(' * ', c);
disp(P);
disp('=>');
disp(' * ',c);
disp(det(P));
disp('This is the characteristic polynomial');
disp(A-B,'Now, A - I = ');
disp(A-2*B,'And, A- 2I = ');
disp(rank(A-B),'rank(A-I) = ');
disp(rank(A-2*B),'rank(A-2I) = ');
disp('W1,W2 be the spaces of characteristic vectors associated with values 1,2');
disp('So by theorem 2, T is diagonalizable');
a1 = [3 -1 3];
a2 = [2 1 0];
a3 = [2 0 1];
disp(a1,'Null space of (T- I) i.e basis of W1 is spanned by a1 = ');
disp('Null space of (T- 2I) i.e. basis of W2 is spanned by vectors x1,x2,x3 such that x1 = 2x1 + 2x3');
disp('One example are;');
disp(a2,'a2 = ');
disp(a3,'a3 = ');
disp('The diagonal matrix is:');
D = [1 0 0 ;0 2 0;0 0 2];
disp(D,'D = ');
disp('The standard basis matrix is denoted as:');
P = [a1;a2;a3]';
disp(P,'P = ');
disp(A*P,'AP = ');
disp(P*D,'PD = ');
disp('That is, AP = PD');
disp('=>  inverse(P)*A*P = D');
//end
