disp('To find a basis for the eigenspace')
disp('Matrix A=')
a=[4 0 1;-2 1 0;-2 0 1]
disp(a)
disp('for lambda=1')
disp('A-1I=')
b=a-eye(3,3)
disp(b)
disp('solving (A-I)x=0, we get')
disp('-2*x1=0 and 3*x1+x3=0')
disp('therefore, x1=x3=0')
disp('which leaves x2 as a free variable')
disp('Hence a basis for the eigen space is:')
disp([0;1;0])
disp('for lambda=2')
disp('A-2I=')
b=a-2*eye(3,3)
disp(b)
disp('performing row operations on the augmented matrix')
c=[b [0;0;0]]
disp(c)
c(2,:)=c(2,:)+c(1,:)
c(3,:)=c(3,:)+c(1,:)
disp(c)
c(1,:)=c(1,:)/c(2,2)
disp(c)
disp('We can see that x3 is a free variable')
disp('x2=x3 and x1=-.05*x3')
disp('Hence, a basis for the eigenspace is:')
disp([-.5;1;1])
disp('for lambda=3')
disp('A-3I=')
b=a-3*eye(3,3)
disp(b)
disp('performing row operations on the augmented matrix')
c=[b [0;0;0]]
disp(c)
c(2,:)=c(2,:)+2*c(1,:)
c(3,:)=c(3,:)+2*c(1,:)
disp(c)
c(2,:)=c(2,:)/2
disp(c)
disp('Again x3 is a free variable')
disp('x1=-x3 and x2=x3')
disp('Hence, a basis for the eigenspace is:')
disp([-1;1;1])