clc
clear
//input data
n=3//Number of stages 
D2=0.4//Outlet impeller diameter in m
b2=0.02//Outlet impeller width in m
b22=45//Backward vanes angle at outlet in degree
dA=0.1//Reduction in circumferential area
nm=0.9//Manometric efficiency of the pump
Q=0.05//Discharge of the pump in m^3/s
N=1000//Running speed of the pump in rpm
n0=0.8//Overall efficiency of the pump
g=9.81//Acceleration due to gravity in m/s^2
d=1000//Density of water in kg/m^3

//calculations
A2=(1-dA)*3.1415*D2*b2//Area of flow at outlet in m^2
Cr2=Q/A2//Flow velocity through impeller at outlet in m/s
U2=(3.1415*D2*N)/60//Outlet impeller tangential velocity in m/s
Wx2=Cr2//Exit relative velocity in m/s as tand(b22)=1
Cx2=U2-Wx2//Absolute whirl velocity in m/s
Hm=(nm*U2*Cx2)/g//Head over which pump has to operate in m
H=n*Hm//Total head generated by the pump in m
P=d*g*Q*Hm*n//Power output from the pump in W
Ps=P/n0*10^-3//Shaft power input in kW

//output
printf('(1)The head generated by the pump is %3.2f m\n(2)Shaft power input is %3.3f kW',H,Ps)
