//Example 1.25
clc
disp("Step 1: Identify topology")
disp("By making Vo = 0, feedback current becomes zero. Hence it is a voltage sampling. The feedback is fed in shunt with the input signal and thus the topology is voltage shunt feedback")
disp("")
disp("Step 2 and Step 3: Find input and output circuit")
disp("To find input circuit, set Vo = 0. This places resistor R across the input. To find output circuit, set V_i = 0. This places resistor R across output. The resultant circuit is shown in fig 1.72")
disp("")
disp("Step 4: Replace FET with its equivalent circuit as shown in fig 1.73")
disp("")
disp("Step 5 : Find open loop transresistance")
disp("R_M = Vo/I_s = -g_m*V_gs*R_eff/I_s")
reff=(40*200*10)/((200*10)+(400)+(40*200))
format(5)
disp(reff,"where  R_eff(in k-ohm) = r_d || R || R_D =")
disp("and  V_gs = I_s*R_i = I_s * R_s||1M||R")
disp("          = I_s * 10K||1M||200K")
disp("          = 9.43*10^3 I_s")
rm=-2.5*9.43*7.69
format(7)
disp(rm,"R_M(in k-ohm) =")
disp("")
disp("Step 6: Calculate beta")
b=-1/(200*10^3)
format(7)
disp("beta = I_f/Io = V_i-Vo/Vo*R =")
disp(b,"     = -1/R =            because (Vo > V_i)")
disp("")
disp("Step 7: Calculate D, R_Mf, A_vf, R_of, R''_of")
d=1+(5*181.29*10^-3)
format(4)
disp(d,"D = 1 + beta*R_M =")
rmf=-181.29/1.9
format(7)
disp(rmf,"R_Mf(in k-ohm) = R_M/D =")
avf=-95.415/10
format(7)
disp(avf,"A_vf = V0/V_s = Vo/I_s*R_s = R_Mf/R_s =")
ri=(10*1000*200)/((1000*200)+(10*200)+(1000*10))
format(5)
disp(ri,"R_i(in k-ohm) = R_s || M || R =")
rif=(9.43)/1.9
format(6)
disp(rif,"R_if(in k-ohm) = R_i/D =")
ro=(40*200*10)/((200*10)+(400)+(40*200))
format(5)
disp(ro,"R''_o(in k-ohm) = r_eff = r_d || R || R_D =")
rof=(7.69/1.9)
format(2)
disp(rof,"R''_of(in k-ohm) = R''_o/D =")
