//Residuals Plot


function residuals_plot(iteration, ures, vres, pres)
    // Ensure iteration count is valid
    if iteration <= 0 then
        disp("Error: Iteration count must be greater than zero.");
        return;
    end

    // Make sure the input vectors are column vectors
    iterVec = (1:iteration)';  // Ensure iteration vector is column
    ures = ures(1:iteration)';  // Ensure ures is column
    vres = vres(1:iteration)';  // Ensure vres is column
    pres = pres(1:iteration)';  // Ensure pres is column

    // Small offset to prevent log(0)
    eps = 1e-10;  
    ures = max(abs(ures), eps);
    vres = max(abs(vres), eps);
    pres = max(abs(pres), eps);

    // Open or create a figure
    scf(1);
    clf(1);

    // Create subplot for convergence history
    subplot(2,1,1);
    semilogy(iterVec, ures, 'b-', 'LineWidth', 2);
    semilogy(iterVec, vres, 'r-', 'LineWidth', 2);
    semilogy(iterVec, pres, 'g-', 'LineWidth', 2);
    
    // Dynamic Y-axis limits
    current_ylim = [min([min(ures), min(vres), min(pres)]), max([max(ures), max(vres), max(pres)])];
    if current_ylim(1) == current_ylim(2) then
        current_ylim(1) = current_ylim(1) / 10;  // Adjust if all residuals are the same
    end
    gca().data_bounds = [1, current_ylim(1); iteration, current_ylim(2)];

    // Default legend without position argument
    legend(["u-velocity", "v-velocity", "pressure"], "lr");

    // Labeling
    xlabel('Iteration');
    ylabel('Residuals');
    title('Convergence History');
    xgrid();

    // Show the plot
    show_window();
endfunction

