// Loading and executing the files in sequence

// Prompt user to select the working directory containing the 'Case' files
case_path = uigetdir('Select the folder containing the CASE files');

if case_path <> "" then
    cd(case_path);
    disp("Working directory set to: " + case_path);
else
    error("No folder selected. Please run the script again and choose a valid directory.");
end

exec('fluid_mesh.sci', -1);       // Load the mesh generation file
exec('functions.sci', -1);        // Load function definitions
exec('residuals_plot.sci', -1);   // Load residual plotting script
exec('simple.sci', -1);           // Load SIMPLE algorithm implementation
exec('output.sci', -1);           // Load output visualization or post-processing


disp("Execution completed successfully!");

disp("The following data prints data for the final iteration.");

disp("The case is solved as an axisymmetric condition ");

