clc;                // Clears the console
clear;              // Removes all variables
funcprot(0)         // Sets function protection mode to '0'


// Get input from the user

mprintf("\nDisclaimer!!!\nMake Sure that you Execute this Program by Saving it in your respective Scilab Workspace....\nBecause about 5 CSV Files would be created and saved during the execution....\n  ");
mprintf("\n");
printf("[<--- Give the value in the range (1 - 1500 MW) --->]");
Pschedule = input("Enter the Planned Power Output: ")                           // Asks for planned power output
printf("[<--- Give the value in the range (0.05 - 0.25) --->]");
KL = input("Enter the Coefficient Reflecting Spinning Reserve Adequacy: ")      // Asks for spinning reserve adequacy coefficient
printf("[<--- Give the value in the range (0.75 - 0.2 per MWh) --->]");
KH = input("Enter the Coefficient Reflecting Environmental Impact: ")           // Asks for environmental impact coefficient


// Define typical percentage range for surplus
surplus_percentage = 0.05; // 5% above Pschedule

// Define typical percentage range for shortage
shortage_percentage = 0.05; // 5% below Pschedule

Ctotal = 0;                                                                       // Initializes total cost to zero
PWF = Pschedule + KL * (Pschedule - Pschedule * exp(-1/KL)) * exp(-KH/KL);        // Calculates the power output with wind forecast

// Calculate EPWF_shortage based on the typical percentage range
adjusted_Pschedule_shortage = Pschedule * (1 - shortage_percentage);
EPWF_shortage = max(0, PWF - (adjusted_Pschedule_shortage * KH) / KL);

//EPWF_shortage = max(0, PWF - (Pschedule * (1 - shortage_percentage) * KH) / KL);   // Calculates the expected power with wind forecast shortage
EPWF_surplus = max(0, Pschedule * (1 + surplus_percentage) - (Pschedule - PWF) / KL); // Calculates the expected power with wind forecast surplus
PWF = max(0, Pschedule - KL * (Pschedule - EPWF_shortage))            // Recalculates the power output with wind forecast considering the shortage
Pr_surplus = 1 - 0.5 * erfc((Pschedule - EPWF_surplus) / (sqrt(2) * EPWF_surplus));
Pr_shortage = 1 - Pr_surplus;


// Calculate efficiency
Efficiency = PWF / Pschedule * 100;             // Calculates efficiency as a percentage

// Assume constant power factor
PF = 0.9;                                       // Assumes a constant power factor of 0.9

// Calculate load factor
LF = PWF / Pschedule;                           // Calculates load factor

// Assume total time of operation in hours
TotalTime = 24;                                 // Assumes total time of operation in hours

// Calculate Capacity Factor
CF = PWF / (Pschedule * TotalTime);             // Calculates capacity factor

// Calculate Energy Yield
EY = PWF * TotalTime;                           // Calculates energy yield

// Assume a placeholder value for Emission Factor
EF = (Ctotal/PWF) + KH + 0.01;                   // Declares a calculative value for emission factor

// Calculate Energy Loss
EL = Pschedule - PWF;                           // Calculates energy loss

// Calculate opportunity costs
CL = abs(KL * Pr_shortage * (Pschedule - EPWF_shortage))        // Calculates opportunity cost for shortage
CH = abs(KH * Pr_surplus * (EPWF_surplus - Pschedule))          // Calculates opportunity cost for surplus

// Calculate overall cost of wind-generated electricity
Ctotal = CL + CH        // Calculates the overall cost of wind-generated electricity by adding the opportunity costs for shortage and surplus



// Print the results
printf("\n----- POWER OUTPUT AND PROBABILITY METRICS -----\n")                        // Prints a section header
printf("Real-time Power Output (PWF): %f\n", PWF)                                   // Prints the real-time power output
printf("Probability of Shortage (Pr_shortage): %f\n", Pr_shortage)                  // Prints the probability of shortage
printf("Probability of Surplus (Pr_surplus): %f\n", Pr_surplus)                     // Prints the probability of surplus
printf("Expected Output during Shortage (EPWF_shortage): %f\n", EPWF_shortage)      // Prints the expected output during shortage
printf("Expected Output during Surplus (EPWF_surplus): %f\n", EPWF_surplus)         // Prints the expected output during surplus

printf("\n----- COST ANALYSIS OF WIND POWER GENERATION -----\n")                           // Prints a section header
printf("Opportunity Cost of Wind Power Shortage (CL) in $ (USD): %f\n", CL)              // Prints the opportunity cost of wind power shortage
printf("Opportunity Cost of Wind Power Surplus (CH) in $ (USD): %f\n", CH)               // Prints the opportunity cost of wind power surplus
printf("Overall Cost of Wind-Generated Electricity (Ctotal) in $ (USD): %f\n", Ctotal)   // Prints the overall cost of wind-generated electricity

// Print the efficiency
printf("\n----- BASIC EFFICIENCY ANALYSIS -----\n")                              // Prints a section header
printf("Efficiency of Power Generation: %f%%\n", Efficiency);            // Prints the efficiency of power generation
printf("Power Factor: %f\n", PF)                                         // Prints the power factor
printf("Load Factor: %f\n", LF);                                         // Prints the load factor
printf("Energy Loss: %f\n", EL);                                         // Prints the energy loss

// Print the Capacity Factor and Energy Yield
printf("\n----- SPECIAL EFFICIENCY ANALYSIS -----\n")                   // Prints a section header
printf("Capacity Factor: %f\n", CF)                                      // Prints the capacity factor
printf("Energy Yield: %f kWh\n", EY);                                    // Prints the energy yield
printf("Emission Factor: %f kg/MWh\n", EF);                              // Prints the emission factor


// Adjust the step size based on Pschedule
step_size = Pschedule / 1000            // Adjusts the step size based on the scheduled power output
x = [0:step_size:Pschedule];            // Creates a range from 0 to the scheduled power output with the step size

// Create a new figure
f = scf();          // Creates a new figure

/* The following lines of code create multiple subplots in the figure, each with a different function plotted against the scheduled power output
Plotting and visualization code goes here */
subplot(3,2,1)                                            // Specifies the first subplot
plot(x, sin(KL * Pr_shortage * (x - EPWF_shortage)), 'r') // Plot sinusoidal function in red
xlabel('Scheduled Power Output')                          // Labels the x-axis
ylabel('Sinusoidal Function')                             // Labels the y-axis
title('Sinusoidal Function vs. Scheduled Power Output')   // Gives the plot a title

subplot(3,2,2)                                             // Specifies the second subplot
plot(x, exp(KH * Pr_surplus * (EPWF_surplus - x)), 'b')    // Plot exponential function in blue
xlabel('Scheduled Power Output')                           // Labels the x-axis
ylabel('Exponential Function')                             // Labels the y-axis
title('Exponential Function vs. Scheduled Power Output')   // Gives the plot a title

subplot(3,2,3)                                                                                      // Specifies the third subplot
plot(x, log(KL * Pr_shortage * (x - EPWF_shortage) + KH * Pr_surplus * (EPWF_surplus - x)), 'g')    // Plot logarithmic function in green
xlabel('Scheduled Power Output')                                                                    // Labels the x-axis
ylabel('Logarithmic Function')                                                                      // Labels the y-axis
title('Logarithmic Function vs. Scheduled Power Output')                                            // Gives the plot a title

subplot(3,2,4)                                                                                      // Specifies the fourth subplot
plot(x, (KL * Pr_shortage * (x - EPWF_shortage) + KH * Pr_surplus * (EPWF_surplus - x)).^2, 'm')    // Plot parabolic function in magenta
xlabel('Scheduled Power Output')                                                                    // Labels the x-axis
ylabel('Parabolic Function')                                                                        // Labels the y-axis
title('Parabolic Function vs. Scheduled Power Output')                                              // Gives the plot a title

y_CL = KL * Pr_shortage * (x - EPWF_shortage);              // Calculates the opportunity cost of shortage
y_CH = KH * Pr_surplus * (EPWF_surplus - x);                // Calculates the opportunity cost of surplus
y_Ctotal = y_CL + y_CH;                                     // Calculates the total cost

plot(x, y_CL, style=2, thickness=2)         // Plot CL in red with a thicker line
plot(x, y_CH, style=5, thickness=2)         // Plot CH in blue with a thicker line
plot(x, y_Ctotal, style=7, thickness=2)     // Plot Ctotal in green with a thicker line

xlabel('Scheduled Power Output')            // Labels the x-axis
ylabel('Cost')                              // Labels the y-axis
legend('CL', 'CH', 'Ctotal')                // Adds a legend to the plot
title('Cost vs. Scheduled Power Output')    // Gives the plot a title

subplot(3,2,5)                                                                                          // Specifies the fifth subplot
plot(x, cumsum(KL * Pr_shortage * (x - EPWF_shortage) + KH * Pr_surplus * (EPWF_surplus - x)), 'C')     // Plot cumulative cost in magenta
xlabel('Scheduled Power Output')                                                                        // Labels the x-axis
ylabel('Cumulative Cost')                                                                               // Labels the y-axis
title('Cumulative Cost Over Time')                                                                      // Gives the plot a title

x = [0:0.1:Pschedule];                              // Adjust this range as needed
y_CL = KL * Pr_shortage * (x - EPWF_shortage);      // Recalculates the opportunity cost of shortage
y_CH = KH * Pr_surplus * (EPWF_surplus - x);        // Specifies the sixth subplot

subplot(3,2,6)                                                      // Specifies the sixth subplot
plot(x, y_CL, 'r')                                                  // Plot CL in red
xlabel('Scheduled Power Output')                                    // Labels the x-axis
ylabel('Opportunity Cost of Shortage')                              // Labels the y-axis
title('Opportunity Cost of Shortage vs. Scheduled Power Output')    // Gives the plot a title


// Create a matrix to store all the input and output values
data = [Pschedule; KL; KH; PWF; EPWF_shortage; EPWF_surplus; Pr_shortage; Pr_surplus; CL; CH; Ctotal];

// Convert the data to a string
data_str = string(data);

// Create a cell array to store the headings
headings = ["Pschedule"; "KL"; "KH"; "PWF"; "EPWF_shortage"; "EPWF_surplus"; "Pr_shortage"; "Pr_surplus"; "CL"; "CH"; "Ctotal"];

// Combine the headings and data into one cell array
csv_data = [headings, data_str];

// Write the data to a CSV file
csvWrite(csv_data, "General_Output_Datas.csv");

// Add the efficiency to your data matrix
data = [data; Efficiency];

// Convert the data to a string
data_str = string(data);

// Add the efficiency heading
headings = [headings; "Efficiency"];

// Combine the headings and data into one cell array
csv_data = [headings, data_str];

// Write the data to a CSV file
csvWrite(csv_data, "General_Output_Datas.csv");

// Add the power factor and load factor to your data matrix
data = [data; PF; LF];

// Convert the data to a string
data_str = string(data);

// Add the new headings
headings = [headings; "Power Factor"; "Load Factor"];

// Combine the headings and data into one cell array
csv_data = [headings, data_str];

// Write the data to a CSV file
csvWrite(csv_data, "General_Output_Datas.csv");

// Add the Capacity Factor and Energy Yield to your data matrix
data = [data; CF; EY];

// Convert the updated data to a string
data_str = string(data);

// Add the new headings
headings = [headings; "Capacity Factor"; "Energy Yield"];

// Combine the headings and data into one cell array
csv_data = [headings, data_str];

// Write the data to a CSV file
csvWrite(csv_data, "General_Output_Datas.csv");

// Add the Emission Factor to your data matrix
data = [data; EF];

// Convert the updated data to a string
data_str = string(data);

// Add the new heading
headings = [headings; "Emission Factor"];

// Combine the headings and data into one cell array
csv_data = [headings, data_str];

// Write the data to a CSV file
csvWrite(csv_data, "General_Output_Datas.csv");

// Add the Energy Loss to your data matrix
data = [data; EL];

// Convert the updated data to a string
data_str = string(data);

// Add the new heading
headings = [headings; "Energy Loss"];

// Combine the headings and data into one cell array
csv_data = [headings, data_str];

// Write the data to a CSV file
csvWrite(csv_data, "General_Output_Datas.csv");


/*-----------------------------------------xxxxx---------------------------------------------*/


//Program for Optimal Power Flow...
// Open the CSV file in write mode
fd = mopen("Optimal_Power_Flow_Datas.csv", "wt");       // Opens the CSV file in write mode
//printf("\n\n")                                        //Leaves a blank line with no contents in it
printf("\n----- OPTIMAL POWER FLOW ANALYSIS -----\n")     // Prints a section header for the optimal power flow analysis


// Prompt the user for system data
n = input("Enter the number of buses in the system: ");       // Asks the user to enter the number of buses
bus_data = zeros(n, 4);                         // Initializes a matrix to store the bus data
for i = 1:n                                     // Loops over each bus
    mprintf("\n----- BUS %d -----\n", i);           // Prints a header for the current bus
    // Asks the user to enter the bus type, real power demand, reactive power demand, and voltage magnitude for the current bus
    printf("\nDISCLAIMER !!!!\nChoose a Valid Bus Type...\nGive the Real Power Demand (Pd) within the Range (1 - 10000 MW)...\nGive the Reactive Power Demand (Qd) within the Range (1 - 10000 MVAR)...\nGive the Voltage Magnitude in Per Units within the Range (0.5 - 1.2 p.u.)...\nGive the Number of Lines in the system within the Range (1 - 1000)...[Recommended Value is Maximum 5, as it would keep iterating till it becomes 0]...\n\n");
    bus_data(i, :) = [input("Choose a Bus Type (1 for Generator Bus & 0 for Load Bus): "), input("Enter the Real Power Demand (Pd) in MW: "), input("Enter the Reactive Power Demand (Qd) in MVAR: "), input("Enter the Voltage Magnitude (V) in Per Unit Values: ")];                              
end


// Write bus data to CSV file
mfprintf(fd, "Bus Type,Real Power Demand (Pd),Reactive Power Demand (Qd),Voltage Magnitude (V)\n");     // Writes the headings for the bus data to the CSV file
for i = 1:n                                                                                             // Loops over each bus
    mfprintf(fd, "%f,%f,%f,%f\n", bus_data(i, :));                                                      // Writes the bus data for the current bus to the CSV file
end

m = input("Enter the number of lines in the system: ");                           // Asks the user to enter the number of lines
line_data = zeros(m, 5);                                                         // Initializes a matrix to store the line data
for i = 1:m                                                                      // Loops over each line
    mprintf("\n----- LINE %d -----\n", i);                                           // Prints a header for the current line
    // Asks the user to enter the from bus, to bus, resistance, reactance, and line capacity for the current line
    printf("\nDISCLAIMER !!!!\nGive the From Bus Value within the Range (1 - 1000)...\nGive the To Bus Value within the Range (1 - 1000)...\nGive the value of Resistance (R - ohms) within the Range (0.001 - 10 ohms/km)...\nGive the value of Reactance (X - ohms) within the Range (0.001 - 10 ohms/km)...\nGive the value of Line Capacity within the Range (1 - 10000 MW)...\n\n");
    line_data(i, :) = [input("Enter From Bus Value in general: "), input("Enter To bus Value in general: "), input("Enter the value for Resistance (R) in ohms/km: "), input("Enter the value for Reactance (X) in ohms/km: "), input("Enter the Line Capacity of the system in MW: ")];
end

// Write line data to CSV file
mfprintf(fd, "From Bus,To Bus,Resistance (R),Reactance (X),Line Capacity\n");       // Writes the headings for the line data to the CSV file
for i = 1:m                                                                         // Loops over each line
    mfprintf(fd, "%f,%f,%f,%f,%f\n", line_data(i, :));                              // Writes the line data for the current line to the CSV file
end


// Define the cost function
function y = cost_function(P)
    y = sum(P.^2) + rand();                 // Quadratic cost function
endfunction                                 // Ends the definition of the cost function

// Define the gradient of the cost function
function g = gradient(P)                    
    g = 2*P;                                // Gradient of the quadratic cost function
endfunction                                 // Ends the definition of the gradient function


// Gradient descent algorithm
P = bus_data(:, 2);                // Sets the initial power generation to the real power demand of each bus
alpha = 0.01;                      // Sets the learning rate for the gradient descent algorithm
mprintf("\nSTARTING GRADIENT DESCENT ALGORITHM...\n");      // Prints a message indicating the start of the gradient descent algorithm
for i = 1:1000                      
    P = P - alpha * gradient(P);                            // Update power generation
    P = min(max(P, bus_data(:, 4)), bus_data(:, 3));        // Enforce generation limits
    if abs(sum(P) - sum(bus_data(:, 2))) < 1e-6             // Check power balance
        break;                                              // If the power balance is within the tolerance, breaks the loop
    end
end


// Write output data to CSV file
mfprintf(fd, "Optimal Power Generation\n");     // Writes a header for the optimal power generation to the CSV file
for i = 1:n                                     // Loops over each bus
    mfprintf(fd, "%f\n", P(i));                 // Writes the optimal power generation for the current bus to the CSV file
end

// Calculate the minimum cost
min_cost = cost_function(P);                    // Calculates the minimum cost using the cost function

// Write the minimum cost to the CSV file
mfprintf(fd, "Minimum Cost\n%f\n", min_cost);   // Writes the minimum cost to the CSV file

// Close the CSV file
mclose(fd);                                     // Closes the CSV file


// Display the results
mprintf("\n----- RESULTS -----\n");                 // Prints a header for the results
mprintf("OPTIMAL POWER GENERATION:\n");         // Prints a subheader for the optimal power generation
for i = 1:n                                     // Loops over each bus
    mprintf("Bus Voltage %d in Per Unit Value: %f\n", i, P(i));  // Prints the optimal power generation for the current bus
end
mprintf("Calculated Minimum Cost in $ (USD): %f\n", min_cost);        // Prints the minimum cost


/*-----------------------------------------xxxxx---------------------------------------------*/


// Print the title of the program
title = "----- WIND TURBINE PERFORMANCE CALCULATOR -----"
mprintf("\n" + title + "\n")

// Ask the user for inputs

mprintf("\n");
printf("[<--- Give the value in the range (1.0 - 1.3 kg/m^3) --->]");
roh = input("Enter the Air Density in kg/m^3: ");
printf("[<--- Give the value in the range (0.1 - 0.5) --->]");
alpha = input("Enter the Alpha Value: ");
printf("[<--- Give the value in the range (10 - 100 m) --->]");
H = input("Enter the Height at which Wind Speed is given in m: ");
printf("[<--- Give the value in the range (50 - 150 m) --->]");
z = input("Enter the Tower Height in m: ");
printf("[<--- Give the value in the range (3 - 25 m/s) --->]");
uH = input("Enter the Wind Speed at given Height in m/s: ");
printf("[<--- Give the value in the range (30 - 150 m) --->]");
D = input("Enter the Diameter of Rotor in m: ");
printf("[<--- Give the value in the range (75 - 95 Percentage) --->]");
effgen = input("Enter the Efficiency of the Generator in %: ");
printf("[<--- Give the value in the range (1 - 25 Percentage) --->]");
reduce = input("Enter the Reduction of Speed in %: ");
printf("[<--- Give the value in the range ($0.05 - $0.50/kWh) --->]");
costPerKWh = input("Enter the Cost per kWh of Electricity: ");
printf("[<--- Give the value in the range (0 - 30 Years) --->]");
lifetime = input("Enter the Lifetime of the Turbine in Years: ");
printf("[<--- Give the value in the range (0.1 - 1.0 kg CO2/kWh) --->]");
carbonFactor = input("Enter the amount of CO2 saved per kWh of renewable energy: ");
printf("[<--- Give the value in the range ($0.05 - $0.50/kWh) --->]");     
backupPowerCost = input("Enter the Cost of Backup Power per kWh: ");
printf("[<--- Give the value in the range (0 - 24 hrs/day) --->]");
downtime = input("Enter the Downtime of the Turbine in hours per day: ");
printf("[<--- Give the value in the range (5 - 30 Percentage) --->]");
variability = input("Enter the Wind Speed Variability in %: ");

u0 = uH*((z/H)^alpha)    // Wind speed at the given height_m/s  
u1 = (1 - (reduce/100))*u0   // Wind speed at the rotor_m/s
A = (%pi/4)*(D^2)   // Area swept by the rotor_m^2

// Print the title of the program
title = "----- CALCULATED TURBINE PERFORMANCES -----"
mprintf("\n" + title + "\n")

mprintf("\n");

// (1) Total power available in wind
P0 = (1/2)*A*roh*(u0^3)
mprintf('Total power available in the wind is = %f Watts\n',P0)

// (2) Power extracted by the turbine
a = (u0 - u1)/u0   // Interference factor
Cp = 4*a*(1 - a)^2    // Power coefficient
Pt = Cp*P0   // Power extracted by the turbine
mprintf('Power Extracted by the Turbine is = %f Watts\n',Pt)

// (3) Electrical power generated
Pe = (effgen/100)*Pt
mprintf('Electrical Power Generated is = %f Watts\n',Pe)

// (4) Axial thrust on the turbine
Fa = 4*a*(1 - a)*(A*roh*((u0^2)/2))
mprintf('Axial Thrust on the Turbine is = %f Newton\n',Fa)

// (5) Maximum axial thrust on the turbine
Famax = A*roh*((u0^2)/2)
mprintf('Maximum Axial Thrust on the Turbine is = %f Newton\n',Famax)

// (6) Cost of electricity generated
cost = (Pe/1000)*costPerKWh  // Convert power to kWh
mprintf('Cost of Electricity Generated is = %f per hour\n',cost)

// (7) Energy produced in a day
energyDay = Pe * 24  // Assuming the turbine operates for 24 hours
mprintf('Energy Produced in a Day is = %f kWh\n', energyDay/1000)

// (8) Factor in downtime
operatingHours = 24 - downtime
energyDayAdjusted = (Pe * operatingHours) / 1000  // Adjusted for downtime
mprintf('Energy Produced in a Day (adjusted for downtime) is = %f kWh\n', energyDayAdjusted)

// (9) Adjust for wind speed variability
u1Adjusted = u1 * (1 - (variability/100))  // Adjusted wind speed at the rotor
aAdjusted = (u0 - u1Adjusted)/u0  // Adjusted interference factor
PtAdjusted = Cp * (1/2) * A * roh * (u0^3)  // Adjusted power extracted by the turbine
mprintf('Power Extracted by the Turbine (adjusted for wind speed variability) is = %f Watts\n', PtAdjusted)

// (10) Lifetime of the turbine
totalEnergy = energyDayAdjusted * 365 * lifetime  // Total energy produced over the lifetime
mprintf('Total Energy Produced over the Lifetime of the Turbine is = %f kWh\n', totalEnergy)

// (11) Carbon emissions saved
carbonSaved = totalEnergy * carbonFactor  // Total carbon emissions saved over the lifetime
mprintf('Total Carbon Emissions Saved over the Lifetime of the Turbine is = %f kg\n', carbonSaved)

// (12) Backup power costs
backupCost = totalEnergy * backupPowerCost  // Total cost of backup power over the lifetime
mprintf('Total Cost of Backup Power over the Lifetime of the Turbine is = %f\n', backupCost)

// Define a function to print the results
function printToCSV(file, heading, value)
    mfprintf(file, "%s,%f\n", heading, value);
endfunction

// Open the CSV file for writing
filename = "Wind_Turbine_Performance.csv";
file = mopen(filename, "w");

// Print and write the results to the CSV file
mprintf("\n");

printToCSV(file, "Total power available in wind (Watts)", P0);
printToCSV(file, "Power extracted by the turbine (Watts)", Pt);
printToCSV(file, "Electrical power generated (Watts)", Pe);
printToCSV(file, "Axial thrust on the turbine (Newton)", Fa);
printToCSV(file, "Maximum axial thrust on the turbine (Newton)", Famax);
printToCSV(file, "Cost of electricity generated (per hour)", cost);
printToCSV(file, "Energy produced in a day (kWh)", energyDay / 1000);
printToCSV(file, "Energy produced in a day (adjusted for downtime) (kWh)", energyDayAdjusted / 1000);
printToCSV(file, "Power extracted by the turbine (adjusted for wind speed variability) (Watts)", PtAdjusted);
printToCSV(file, "Total energy produced over the lifetime of the turbine (kWh)", totalEnergy);
printToCSV(file, "Total carbon emissions saved over the lifetime of the turbine (kg)", carbonSaved);
printToCSV(file, "Total cost of backup power over the lifetime of the turbine", backupCost);

// Close the CSV file
mclose(file);


/*-----------------------------------------xxxxx---------------------------------------------*/


// Print the title of the program
title = "----- ECONOMIC LOAD DISPATCH EXCLUDING LOSSES -----";
mprintf("\n" + title + "\n");

mprintf("\n");

// Ask the user for inputs
mprintf("[<--- Recommended 3 Units in the system --->]");
num = input("Enter the Number of Units in the system: ");   // Number of units
mprintf("[<--- Add space for separating each Element and colon for seperating each Row --->]\n");
mprintf("[<--- (For Example - [0.05 23.5 700;0.2 20 850;0.09 18 960]) --->]]");
Function = input("Enter the Cost Coefficient in Matrix Form: ");   // Cost coefficients for each unit
mprintf("[<--- Add space for separating each Element and colon for seperating each Row --->]\n");
mprintf("[<--- (For Example - [40 150;40 150;40 150]) --->]]");
constraint = input("Enter Minimum and Maximum Values of Power for all Units: ");   // Power constraints for each unit
mprintf("[<--- Give the value in the range (1 - 1000 MW)  --->]");
pd = input("Enter Total Demand: ");   // Total power demand
a = Function(:, 1);   // First column of Function matrix
b = Function(:, 2);   // Second column of Function matrix
c = Function(:, 3);   // Third column of Function matrix
Pmin = constraint(:, 1);   // Minimum power for each unit
Pmax = constraint(:, 2);   // Maximum power for each unit
chk = zeros(num, 1);   // Initialize check array to zeros
rem = 1;   // Initialize remainder to 1

// Calculate the optimum schedule
while rem == 1
    sx = 0; 
    sy = 0;
    for i = 1:num
        if i ~= chk(i)
            sx = sx + b(i) / (2 * a(i));   // Calculate sum of b(i) / (2 * a(i)) for all unchecked units
            sy = sy + 1 / (2 * a(i));      // Calculate sum of 1 / (2 * a(i)) for all unchecked units
        end
    end
    lamda = (pd + sx) / sy;   // Calculate lambda
    sch = 0;
    for i = 1:num
        if i ~= chk(i)
            P(i) = (lamda - b(i)) / (2 * a(i));   // Calculate power for each unchecked unit
            if P(i) < Pmin(i) | P(i) > Pmax(i)    // Check if power is within constraints
                if P(i) < Pmin(i)
                    P(i) = Pmin(i);    // If power is less than minimum, set it to minimum
                else
                    P(i) = Pmax(i);    // If power is more than maximum, set it to maximum
                end
                pd = pd - P(i);    // Subtract power of current unit from total demand
                chk(i) = i;        // Mark current unit as checked
                sch = sch + 1;     // Increment schedule
            end
        end
        if sch == 0
            rem = 0;    // If schedule is 0, set remainder to 0
        else
            rem = 1;    // If schedule is not 0, set remainder to 1
        end
    end
end

// Display the optimum schedule
mprintf("The Optimum Schedule is:\n");
mprintf("    %f\n", P);    // Print optimum schedule

// Open the CSV file for writing
filename_excluding_losses = "Economic_Load_Dispatch_Excluding_Losses.csv";
file_excluding_losses = mopen(filename_excluding_losses, "w");

// Print the input values to CSV
mprintf("\n");
mfprintf(file_excluding_losses, "Input Values\n");
mfprintf(file_excluding_losses, "Number of Units,%d\n", num);   // Print number of units
mfprintf(file_excluding_losses, "Cost Coefficient a,Cost Coefficient b,Cost Coefficient c\n");   // Print cost coefficients
for i = 1:num
    mfprintf(file_excluding_losses, "%f,%f,%f\n", a(i), b(i), c(i));   // Print cost coefficients for each unit
end
mfprintf(file_excluding_losses, "Minimum Power,Maximum Power\n");      // Print power constraints
for i = 1:num
    mfprintf(file_excluding_losses, "%f,%f\n", Pmin(i), Pmax(i));      // Print power constraints for each unit
end
mfprintf(file_excluding_losses, "Total Demand,%f\n", pd);              // Print total demand

// Print the optimum schedule to CSV
mfprintf(file_excluding_losses, "\nOptimum Schedule\n");    // Print optimum schedule
for i = 1:num
    mfprintf(file_excluding_losses, "%f\n", P(i));          // Print power for each unit
end

// Close the CSV file
mclose(file_excluding_losses);


/*-----------------------------------------xxxxx---------------------------------------------*/


// Print the title of the program
title_including_losses = "----- ECONOMIC LOAD DISPATCH INCLUDING LOSSSES -----";
mprintf("\n" + title_including_losses + "\n");

mprintf("\n");

// (Your existing input prompts here)
mprintf("[<--- Recommended 3 Units in the system --->]");
num = input("Enter the Number of Units in the system: ");                            // Number of units
mprintf("[<--- Add space for separating each Element and colon for seperating each Row --->]\n");
mprintf("[<--- (For Example - [0.01 -0.0003 -0.0002;-0.0003 0.0025 -0.0005;-0.0002 -0.0005 0.0031]) --->]]");
B = input("Enter the Loss Coefficient in Matrix Form: ");              // Loss coefficients for each unit
a = B(:, 1);       // First column of B matrix
b = B(:, 2);       // Second column of B matrix
c = B(:, 3);       // Third column of B matrix
mprintf("[<--- Add space for separating each Element and colon for seperating each Row --->]\n");
mprintf("[<--- (For Example - [50/200 100/200 200/200]) --->]]");
pg = input("Enter the Power of the Units in Matrix Form in Per Unit Values: ");    // Power of each unit
mprintf("[<--- Give the value in the range (1 - 1000 MW) --->]]");
bv = input("Enter the Base Value: ");    // Base value
pl = 0;
for i = 1:num //Calculation of Power Loss
    for j = 1:num       // Calculate power loss 
        pl = pl + pg(j) * B(i, j) * pg(i);
    end
end
mprintf("The Transmission Loss in p.u. is:\n");
mprintf("    %f\n", pl);        // Print power loss
ITL = zeros(num, 1);        // Initialize incremental transmission loss to zeros
for i = 1:num               // Calculate incremental transmission loss
    for j = 1:num
        ITL(i) = ITL(i) + 2 * B(i, j) * pg(j);
    end
end
mprintf("The Incremental Loss in p.u. are:\n");
for i = 1:size(ITL, 1)
    mprintf("    %f\n", ITL(i));        // Print incremental transmission loss
end

// Print and write the results to the CSV file
mprintf("\n");

// Define a function to print the results to CSV
function printToCSV(file, heading, value)
    // If the value is a vector, print each element with the heading
    if size(value, 1) > 1
        for i = 1:size(value, 1)
            mfprintf(file, "%s,%f\n", heading, value(i));
        end
    else
        // If the value is a scalar, print it with the heading
        mfprintf(file, "%s,%f\n", heading, value);
    end
endfunction

// Open the CSV file for writing
filename_including_losses = "Economic_Load_Dispatch_Including_Losses.csv";
file_including_losses = mopen(filename_including_losses, "w");

printToCSV(file_including_losses, "Number of Units", num);      // Print number of units to CSV
printToCSV(file_including_losses, "Transmission Loss", pl);     // Print power loss to CSV
printToCSV(file_including_losses, "Incremental Loss", ITL);     // Print incremental transmission loss to CSV

// Close the CSV file
mclose(file_including_losses);
