clc;
clear;
close;

// Parameters
N = 100;                 // Number of users
R = 100;                // Radius of user distribution area (meters)
B = 10e6;               // Bandwidth in Hz
SNR_dB =-10:50          // Received SNR in dB
SNR = 10^(SNR_dB/ 10);
N0 = 10e-8; // Noise power in Watts
f = 3e9;                // Frequency in Hz
c = 3e8;                // Speed of light in m/s

a1 = [0.1];             b1 = [21];      // Environmental Parameters
alpha1 = [5.2];         beta1 = [0.35];

eta_los = 10 * log10(a1);               // LOS excessive path loss 
eta_Nlos = 10 * log10(b1);              // NLOS excessive path loss 

// Generate user positions
r = R * sqrt(rand(1, N));            // Random distances within radius
theta = 2 * %pi * rand(1, N);        // Random angles
x = r .* cos(theta);                 // x-coordinates of users
y = r .* sin(theta);                 // y-coordinates of users
altitude =[100 500 1000];
for i=1:3
for j = 1:length(SNR)
 

    // Calculate distances from UAV to users
    distances = sqrt(r.^2 + altitude(i)^2);          // Distance from UAV to each user

    // Path loss calculations
    A = eta_los - eta_Nlos;
    B = 10 * log10(distances) + 20 * log10((4 * %pi * f) / c) + eta_Nlos;
    theta_1 = (180 / %pi) * atan(altitude(i) ./ sqrt(r.^2));
    P_L1 = A ./ (1 + (alpha1 * exp(-beta1 * (theta_1 - alpha1))));  
    P_L = P_L1 + B;                              // Path loss for each user       
    PL_linear = 10.^(P_L/10);            // Convert dB to linear scale

    // Data rate for each user
    SINR = (SNR(j)) ./ (PL_linear.*N0.*B);        // SINR (scalar division)
    R_users = B.*log2(1 + SINR);                // Data rate for each user
    R_total = sum(R_users);         // Total data rate across all users   
    Data_rate(j) = R_total / N;
end
colors = ["b", "r", "g"]; // Blue, Red, Green, Magent
plot(SNR_dB, Data_rate*1e-3, colors(i),"LineWidth", 2);
end
//plot(optimal_altitude, max_EE, "ro", "MarkerSize", 8); // Mark optimal point
xlabel("UAV Transmit Power (dBm)");
ylabel("Network Sum Date Rate (Kbps/Hz)");
title("Sum Date Rate vs. UAV Transmit Power");
legends = ["h=100","h=500", "h=1000"];
legend(legends, "Location", "northwest");
xgrid


