// 3D User Distribution Model in SCILAB
clc
clear 
close
// Parameters
num_users = 50; // Number of users
area_size = 1000; // Size of the area (1000m x 1000m)
uav_altitude = 500; // UAV altitude in meters

// Generate user positions
x_users = rand(1, num_users) * area_size - area_size / 2; // x-coordinates in range [-500, 500]
y_users = rand(1, num_users) * area_size - area_size / 2; // y-coordinates in range [-500, 500]
z_users = zeros(1, num_users); // z-coordinate is 0 (ground level)

// UAV Position
x_uav = 0; // UAV at the center
y_uav = 0;
z_uav = uav_altitude;

// Plotting
clf; // Clear the current figure
scatter3d(x_users, y_users, z_users,100,"fill"); // Users as blue dots
scatter3d([x_uav], [y_uav], [z_uav], 100,20,"*",'thickness',3); // UAV as a red dot with larger size
gca().rotation_angles = [60, 50];
xlabel("X-axis (meters)");
ylabel("Y-axis (meters)");
zlabel("Altitude (meters)");
xtitle("3D User Distribution Model");


legend(["Users (Ground Level)", "UAV (Altitude)"]);
