clc;
clear;

disp("ACC Simulation with PD Gain Scheduling");

dt = input("Time step (s): ");
tend = input("Total simulation time (s): ");
dsafe = input("Safe following distance (m): ");
vref = input("Reference velocity (m/s): ");

disp("Enter vehicle mass for each phase (kg):");
m = [];
for i = 1:4
    m(i) = input("Mass for phase " + string(i) + ": ");
end

disp("Enter PD gains (Kp, Kd) for each phase:");
Kp = [];
Kd = [];
for i = 1:4
    Kp(i) = input("Kp for phase " + string(i) + ": ");
    Kd(i) = input("Kd for phase " + string(i) + ": ");
end

t = 0:dt:tend;
x = [0; 0];
derr = [];
vtrack = [];
gains = [];
reldist = [];
uctrl = [];

disp("Enter duration for each phase (s):");
ptime = [];
for i = 1:4
    ptime(i) = input("Duration for phase " + string(i) + ": ");
end

posact = 85;
phase = 1;
vact = 35;

for k = 1:length(t)
    if phase <= length(ptime) && t(k) > sum(ptime(1:phase))
        phase = phase + 1;
        if phase > length(m) then
            break;
        end
    end

    mass = m(phase);
    Kpval = Kp(phase);
    Kdval = Kd(phase);

    A = [0 1; 0 -50/mass];
    B = [0; 1/mass];

    vact = 35 + 5 * sin(0.1 * t(k));
    posact = posact + vact * dt;

    drel = posact - x(1);
    vrel = vact - x(2);

    if drel > dsafe then
        u = Kpval * (vref - x(2));
    else
        u = Kpval * drel + Kdval * vrel;
    end

    xdot = A * x + B * u;
    x = x + xdot * dt;

    reldist = [reldist, drel];
    vtrack = [vtrack, x(2)];
    derr = [derr, drel - dsafe];
    gains = [gains; Kpval, Kdval];
    uctrl = [uctrl, u];
end

subplot(3, 1, 1);
plot(t(1:length(derr)), derr, 'b');
xlabel("Time (s)");
ylabel("Distance Error (m)");
title("Distance Error vs. Time");

subplot(3, 1, 2);
plot(t(1:length(vtrack)), vtrack, 'r');
xlabel("Time (s)");
ylabel("Vehicle Velocity (m/s)");
title("Vehicle Velocity vs. Time");

subplot(3, 1, 3);
plot(t(1:length(uctrl)), uctrl, 'g');
xlabel("Time (s)");
ylabel("Control Input (N)");
title("Control Input vs. Time");


