//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

chess=chess2;  //Making copy of the variable "chess2" for using that later if required in the scilab console  

[r_chess,b_chess,g_chess]=RGB_splitter(chess); //RGB_splitter(image) function takes the RGB image as input and gives 3 outputs 
//namely;-Red channel .Blue channel , Green channel.listed below  
r_chess = im2double(r_chess);
b_chess = im2double(b_chess);
g_chess = im2double(g_chess);



[h w]=size(r_chess);//computing the rows and columns using size() function 

t = im2double(imread('scilabcloud.jpg'));//Reading the noise added and converting into double for futher computation.
//t= rgb2gray(t);
t = imresize(t,0.3);// Resizing the image since resolution of picture is too high. 
t = t(1:size(chess,1),1:size(chess,2));// cropping the noise in accordance to the input image.



//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// PARAMETERS OF THE MODEL --> s=alpha*L*r(x,y)*t(x,y) + L[1-t(x,y)]

//MODEL DESCRIPTION
/*s=alpha*L*r(x,y)*t(x,y) + L[1-t(x,y)]
    s - L = alpha*L*r(x,y)*t(x,y) - L*t(x,y);
    
    L - s = [L - alpha*L*r(x,y)]t(x,y)
    
    Now taking the log both sides 
    
    log(L-s) = log(t(x,y) + log(L - alpha*L*r(x,y));
    */
    
//alpha = 1; This parameter is shifted to the Case_study2.sce file for avoiding problem of DOUBLE COUNTING--> Problem where a same variable would be required to 
//           change in many file whereas it should remain same for all the files.
L_r = max(r_chess(:));// brightest pixel 
L_b = max(b_chess(:));// brightest pixel
L_g = max(g_chess(:));// brightest pixel

//NOTE:- here since the image is in the RGB format so it requires first convertion of it into the 3 channels and the applying the same concept similar to the implementation of the gray scale image   
r_red = r_chess; // r= desired image in red channel
r_blue = b_chess; // r= desired image in blue channel 
r_green = g_chess; // r= desired image in green channel
//BUT r_red, r_blue, r_green won't show the red image since the image is actually only 2 dimensional matrix and so to show image as red/blue/green channel
//first convert it into the 3 dimensional matrix using " cat()" command as done in RGB_combiner.sci file  

//----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// computation of the model for different channels
s_red = (((alpha*L_r).*r_red).*t) + L_r.*(1-t);
s_blue = (((alpha*L_b).*r_blue).*t) + L_b.*(1-t);
s_green = (((alpha*L_g).*r_green).*t) + L_g.*(1-t);

// Recombination of 3 channels;
s = RGB_recombiner(s_red,s_blue,s_green,chess);// "s" is the corrupted image recieved by the satellite or simply the scanner image as mentioned in the documentation.
 
//subplot(223)
figure;
//subplot(121)
imshow(s);
title('input')
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

raw_input_red = log(L_r-s_red +0.00001);//here 0.000001 is used since due to model used it may happen L=s and in that case "Log(L-s)-->(negative infinity)".Since Log(0)= -(infinity)
raw_input_blue = log(L_b-s_blue +0.00001);
raw_input_green = log(L_g-s_green +0.00001);


// FFT Transform of raw_input in 3 channels
raw_input_fft_red = fft2(raw_input_red);
raw_input_fft_blue = fft2(raw_input_blue);
raw_input_fft_green = fft2(raw_input_green);


//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// Ideal low pass filter
Hj=ideal_lpf(chess,100);
    //Inverse FFT 
    hj=ifft2(bool2s(Hj));//bool2s() is used since the Hj is the boolean variable having(T/F) and to convert it to (1 or 0) fo rthe computation.
        // Kaiser Window
        kaiser_coefficient = 1;    //kaiser_coefficient 	window shape
                                  //        0           	Rectangular shape
                                 //         5          	Similar to the Hamming window
                                //          6           	Similar to the Hanning window
                               //           8.6         	Similar to the Blackman window
        w= window2(h,w,kaiser_coefficient);
        //multiplication of the ideal low pass filter spatialresponse and window function or in (time domain in vague sense)  
        h_spatial=hj.*w;
    //Fourier transrom for getting the frequency response of the system. 
    H_uv=fft2(h_spatial);
   
//Output steps 
    //stage 1
    //frequency domain multiplication of raw_input_fft with H_uv to produce 
    //output in frquency domain.
    Output_in_frequency_domain_red = raw_input_fft_red.*H_uv;
    Output_in_frequency_domain_blue = raw_input_fft_blue.*H_uv;
    Output_in_frequency_domain_green = raw_input_fft_green.*H_uv;
    
    //stage 2
    // IFFT of the previous frequency domain output
    Output_in_time_domain_red = ifft2(Output_in_frequency_domain_red);
    Output_in_time_domain_blue = ifft2(Output_in_frequency_domain_blue);
    Output_in_time_domain_green = ifft2(Output_in_frequency_domain_green);
    
    //stage 3 removing exponent and obtaining the noise calculated usin the model 
    t_new_red = exp(Output_in_time_domain_red);
    t_new_blue = exp(Output_in_time_domain_blue);
    t_new_green = exp(Output_in_time_domain_green);
    
    //ifftshow(t_new);
    //title('t_new');
    //----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    
    
    //NOTE:- Here the noise obtained is plugged in the inverse equation of the model to get output image in 3 channels  
    output_image_red = ((L_r/alpha) - ((L_r-s_red)./(alpha*(t_new_red))));
    output_image_blue = ((L_b/alpha) - ((L_b-s_blue)./(alpha*(t_new_blue))));
    output_image_green = ((L_g/alpha) - ((L_g-s_green)./(alpha*(t_new_green))));
   
    //ifftshow2 is used to show the image after inverse fourier transform of the image ;
    get_red = ifftshow2((output_image_red));
    get_blue = ifftshow2((output_image_blue));
    get_green = ifftshow2((output_image_green));
    
    //Histogram equalization is done for enhancing the image quality.
    imh1_red = imhistequal(get_red);
    imh1_blue = imhistequal(get_blue);
    imh1_green = imhistequal(get_green);
    
    //RGB_recombiner is used to get the image combined from all the channel  
    imh1 = RGB_recombiner(imh1_red,imh1_blue,imh1_green,chess);
    
    //shows the output
    figure;
    imshow(imh1);title('Output');
    
    


    



