// Clear console and figures
clc;
clf;

// Take input from user
xi = input("Enter initial position along the x-axis (starting point of the length of the building) (in meters): ");  
xf = input("Enter final position along the x-axis (endpoint of the length of the building) (in meters): ");   
hx = input("Enter step size for x (distance between discrete measurement points along the x-axis) (in meters): ");      

ti = input("Enter initial time (starting point of the simulation) (in seconds): ");  
ht = input("Enter time step size (duration of each time step) (in seconds): ");   
nt = input("Enter number of time steps (total duration of the simulation) (dimensionless): ");  

// Generate arrays for spatial and time domains
x = xi:hx:xf;         // Create x array
t = ti:ht:(ti + nt * ht);

// Calculate number of intervals
n = (xf - xi) / hx;

// Calculate coefficient r
r = ht / (hx * hx);

// Initialize temperature matrix
u = zeros(n + 1, nt + 1);

// Set default boundary condition at x = 0 and x = 1
u(1, 1) = 0;
u(n + 1, 1) = 0;

// Set initial condition for u(x,0)
for i = 2:n
    u(i, 1) = sin(%pi * x(i));  // Initializes the temperature distribution at initial time t=0 based on sinusoidal function 
end

// Initialize matrices for implicit scheme
a = zeros(n - 1, n - 1);
b = zeros(n - 1, n - 1);

for i = 1:n - 2
    a(i, i) = 2 + 2 * r;
    a(i, i + 1) = -r;
    a(i + 1, i) = -r;
    b(i, i) = 2 - 2 * r;
    b(i, i + 1) = r;
    b(i + 1, i) = r;
end

a(n - 1, n - 1) = 2 + 2 * r;    // Set the last element of matrix a
b(n - 1, n - 1) = 2 - 2 * r;    // Set the last element of matrix b

disp('Matrix a:'); disp(a);     // Represents the coefficients of the central finite difference approximation for the second derivative with respect to space i.e it calculates the temperature values at the next time step based on the temperature values at the current time step.

disp('Matrix b:'); disp(b);     // calculate the temperature values at the next time step based on the temperature values at the previous time step i.e. it represents the coefficients of the implicit time-stepping scheme used to solve the heat equation.

// Advances the simulation of the heat equation by one time step at each iteration. It maintains the boundary conditions and updates the temperature profile inside the domain using an implicit finite difference scheme.
for j = 1:nt               // Perform time-stepping loop
    u(1, j + 1) = u(1, j);                 // Boundary condition at x = 0
    u(2:n, j + 1) = inv(a) * ((b) * (u(2:n, j)));  // Update u using the implicit scheme
    u(n + 1, j + 1) = u(n + 1, j);         // Boundary condition at x = 1
end

disp('u:'); disp(u);        // Display u matrix

figure(0);
plot(x', u, 'd-', 'linewidth', 4);     // Plot the results
xlabel("x - position", "fontsize", 6); ylabel("u - temperature", "fontsize", 6); zlabel("u", "fontsize", 6); // Set labels
legend('t=' + string(t), 5);    

figure(1);
plot3d(x, t, u);  // Plot in 3D
xlabel("x - position", "fontsize", 6); ylabel("u - temperature", "fontsize", 6); zlabel("u", "fontsize", 6); // Set labels
