// This function is used to to segment the image using a canny edge detection
 


function e=Automode(a)
    img=rgb2gray(a)// RGB image converted to grayscale
e=edge(img,'canny',[0.7 0.9]); // Canny edge detection operator with threshold values used
[m,n]=size(e)// Size of image gives ellipse parameters so that ellipse used is propotional to the size of image
m=m/100
n=n/100
m=m*n// m is used to calculate the ellipse size as images are variable 
m=sqrt(m)
x='y'
while(x=='y')// Loop used to dillate the image again if the user is not satisfied
se = imcreatese('ellipse',m+2,m+2); // variable ellipse created which changes with image size
e=imdilate(e,se);// Image is dialated to fill the inside of the object
e=imfill(e)// Holes in the image are filled
m=m/2// Ellipse for erosion is half of dilation
se = imcreatese('ellipse',m,m);
delete(gca().children);
e=imerode(e,se);// Image is eroded
imshow(e);// Image is displayed to user
disp('Are you satisfied with segmentation?')// User is asked if the Auto mode worked correctly
x=input(" Press enter key to continue and y to retry ","string")
if(x=='y'||x==' y')
    disp('retrying again');
end
end

endfunction
